/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ram.model.PolicyListCopier;
import software.amazon.awssdk.services.ram.model.RamResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePoliciesResponse
extends RamResponse
implements ToCopyableBuilder<Builder, GetResourcePoliciesResponse> {
    private static final SdkField<List<String>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policies").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::policies)).setter(GetResourcePoliciesResponse.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::nextToken)).setter(GetResourcePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> policies;
    private final String nextToken;

    private GetResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<String> policies() {
        return this.policies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesResponse)) {
            return false;
        }
        GetResourcePoliciesResponse other = (GetResourcePoliciesResponse)((Object)obj);
        return this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePoliciesResponse").add("Policies", this.hasPolicies() ? this.policies() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesResponse, T> g) {
        return obj -> g.apply((GetResourcePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamResponse.BuilderImpl
    implements Builder {
        private List<String> policies = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesResponse model) {
            super(model);
            this.policies(model.policies);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPolicies() {
            if (this.policies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policies;
        }

        @Override
        public final Builder policies(Collection<String> policies) {
            this.policies = PolicyListCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(String ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        public final void setPolicies(Collection<String> policies) {
            this.policies = PolicyListCopier.copy(policies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetResourcePoliciesResponse build() {
            return new GetResourcePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePoliciesResponse> {
        public Builder policies(Collection<String> var1);

        public Builder policies(String ... var1);

        public Builder nextToken(String var1);
    }
}

