/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FileFormat {
    CSV("CSV"),
    TSV("TSV"),
    CLF("CLF"),
    ELF("ELF"),
    XLSX("XLSX"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FileFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FileFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileFormat> knownValues() {
        return Stream.of(FileFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

