/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Edition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountSettings> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(AccountSettings.getter(AccountSettings::accountName)).setter(AccountSettings.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(AccountSettings.getter(AccountSettings::editionAsString)).setter(AccountSettings.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<String> DEFAULT_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultNamespace").getter(AccountSettings.getter(AccountSettings::defaultNamespace)).setter(AccountSettings.setter(Builder::defaultNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNamespace").build()}).build();
    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NotificationEmail").getter(AccountSettings.getter(AccountSettings::notificationEmail)).setter(AccountSettings.setter(Builder::notificationEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD, EDITION_FIELD, DEFAULT_NAMESPACE_FIELD, NOTIFICATION_EMAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountName;
    private final String edition;
    private final String defaultNamespace;
    private final String notificationEmail;

    private AccountSettings(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.edition = builder.edition;
        this.defaultNamespace = builder.defaultNamespace;
        this.notificationEmail = builder.notificationEmail;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final Edition edition() {
        return Edition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public final String defaultNamespace() {
        return this.defaultNamespace;
    }

    public final String notificationEmail() {
        return this.notificationEmail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEmail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings)obj;
        return Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.defaultNamespace(), other.defaultNamespace()) && Objects.equals(this.notificationEmail(), other.notificationEmail());
    }

    public final String toString() {
        return ToString.builder((String)"AccountSettings").add("AccountName", (Object)this.accountName()).add("Edition", (Object)this.editionAsString()).add("DefaultNamespace", (Object)this.defaultNamespace()).add("NotificationEmail", (Object)this.notificationEmail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "DefaultNamespace": {
                return Optional.ofNullable(clazz.cast(this.defaultNamespace()));
            }
            case "NotificationEmail": {
                return Optional.ofNullable(clazz.cast(this.notificationEmail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountName;
        private String edition;
        private String defaultNamespace;
        private String notificationEmail;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            this.accountName(model.accountName);
            this.edition(model.edition);
            this.defaultNamespace(model.defaultNamespace);
            this.notificationEmail(model.notificationEmail);
        }

        public final String getAccountName() {
            return this.accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getEdition() {
            return this.edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        public final String getDefaultNamespace() {
            return this.defaultNamespace;
        }

        @Override
        public final Builder defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public final void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        public final String getNotificationEmail() {
            return this.notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        public AccountSettings build() {
            return new AccountSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountSettings> {
        public Builder accountName(String var1);

        public Builder edition(String var1);

        public Builder edition(Edition var1);

        public Builder defaultNamespace(String var1);

        public Builder notificationEmail(String var1);
    }
}

