/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.outposts.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.outposts.model.OutpostsResponse;
import software.amazon.awssdk.services.outposts.model.Site;
import software.amazon.awssdk.services.outposts.model._siteListDefinitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSitesResponse
extends OutpostsResponse
implements ToCopyableBuilder<Builder, ListSitesResponse> {
    private static final SdkField<List<Site>> SITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sites").getter(ListSitesResponse.getter(ListSitesResponse::sites)).setter(ListSitesResponse.setter(Builder::sites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Site::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSitesResponse.getter(ListSitesResponse::nextToken)).setter(ListSitesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SITES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Site> sites;
    private final String nextToken;

    private ListSitesResponse(BuilderImpl builder) {
        super(builder);
        this.sites = builder.sites;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSites() {
        return this.sites != null && !(this.sites instanceof SdkAutoConstructList);
    }

    public final List<Site> sites() {
        return this.sites;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSites() ? this.sites() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSitesResponse)) {
            return false;
        }
        ListSitesResponse other = (ListSitesResponse)((Object)obj);
        return this.hasSites() == other.hasSites() && Objects.equals(this.sites(), other.sites()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSitesResponse").add("Sites", this.hasSites() ? this.sites() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sites": {
                return Optional.ofNullable(clazz.cast(this.sites()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSitesResponse, T> g) {
        return obj -> g.apply((ListSitesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OutpostsResponse.BuilderImpl
    implements Builder {
        private List<Site> sites = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSitesResponse model) {
            super(model);
            this.sites(model.sites);
            this.nextToken(model.nextToken);
        }

        public final List<Site.Builder> getSites() {
            List<Site.Builder> result = _siteListDefinitionCopier.copyToBuilder(this.sites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sites(Collection<Site> sites) {
            this.sites = _siteListDefinitionCopier.copy(sites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sites(Site ... sites) {
            this.sites(Arrays.asList(sites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sites(Consumer<Site.Builder> ... sites) {
            this.sites(Stream.of(sites).map(c -> (Site)((Site.Builder)Site.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSites(Collection<Site.BuilderImpl> sites) {
            this.sites = _siteListDefinitionCopier.copyFromBuilder(sites);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSitesResponse build() {
            return new ListSitesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OutpostsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSitesResponse> {
        public Builder sites(Collection<Site> var1);

        public Builder sites(Site ... var1);

        public Builder sites(Consumer<Site.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

