/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mwaa.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mwaa.model.ModuleLoggingConfigurationInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfigurationInput> {
    private static final SdkField<ModuleLoggingConfigurationInput> DAG_PROCESSING_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DagProcessingLogs").getter(LoggingConfigurationInput.getter(LoggingConfigurationInput::dagProcessingLogs)).setter(LoggingConfigurationInput.setter(Builder::dagProcessingLogs)).constructor(ModuleLoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DagProcessingLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfigurationInput> SCHEDULER_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchedulerLogs").getter(LoggingConfigurationInput.getter(LoggingConfigurationInput::schedulerLogs)).setter(LoggingConfigurationInput.setter(Builder::schedulerLogs)).constructor(ModuleLoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfigurationInput> TASK_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaskLogs").getter(LoggingConfigurationInput.getter(LoggingConfigurationInput::taskLogs)).setter(LoggingConfigurationInput.setter(Builder::taskLogs)).constructor(ModuleLoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfigurationInput> WEBSERVER_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WebserverLogs").getter(LoggingConfigurationInput.getter(LoggingConfigurationInput::webserverLogs)).setter(LoggingConfigurationInput.setter(Builder::webserverLogs)).constructor(ModuleLoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebserverLogs").build()}).build();
    private static final SdkField<ModuleLoggingConfigurationInput> WORKER_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkerLogs").getter(LoggingConfigurationInput.getter(LoggingConfigurationInput::workerLogs)).setter(LoggingConfigurationInput.setter(Builder::workerLogs)).constructor(ModuleLoggingConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerLogs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAG_PROCESSING_LOGS_FIELD, SCHEDULER_LOGS_FIELD, TASK_LOGS_FIELD, WEBSERVER_LOGS_FIELD, WORKER_LOGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ModuleLoggingConfigurationInput dagProcessingLogs;
    private final ModuleLoggingConfigurationInput schedulerLogs;
    private final ModuleLoggingConfigurationInput taskLogs;
    private final ModuleLoggingConfigurationInput webserverLogs;
    private final ModuleLoggingConfigurationInput workerLogs;

    private LoggingConfigurationInput(BuilderImpl builder) {
        this.dagProcessingLogs = builder.dagProcessingLogs;
        this.schedulerLogs = builder.schedulerLogs;
        this.taskLogs = builder.taskLogs;
        this.webserverLogs = builder.webserverLogs;
        this.workerLogs = builder.workerLogs;
    }

    public final ModuleLoggingConfigurationInput dagProcessingLogs() {
        return this.dagProcessingLogs;
    }

    public final ModuleLoggingConfigurationInput schedulerLogs() {
        return this.schedulerLogs;
    }

    public final ModuleLoggingConfigurationInput taskLogs() {
        return this.taskLogs;
    }

    public final ModuleLoggingConfigurationInput webserverLogs() {
        return this.webserverLogs;
    }

    public final ModuleLoggingConfigurationInput workerLogs() {
        return this.workerLogs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dagProcessingLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulerLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.webserverLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerLogs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfigurationInput)) {
            return false;
        }
        LoggingConfigurationInput other = (LoggingConfigurationInput)obj;
        return Objects.equals(this.dagProcessingLogs(), other.dagProcessingLogs()) && Objects.equals(this.schedulerLogs(), other.schedulerLogs()) && Objects.equals(this.taskLogs(), other.taskLogs()) && Objects.equals(this.webserverLogs(), other.webserverLogs()) && Objects.equals(this.workerLogs(), other.workerLogs());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingConfigurationInput").add("DagProcessingLogs", (Object)this.dagProcessingLogs()).add("SchedulerLogs", (Object)this.schedulerLogs()).add("TaskLogs", (Object)this.taskLogs()).add("WebserverLogs", (Object)this.webserverLogs()).add("WorkerLogs", (Object)this.workerLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DagProcessingLogs": {
                return Optional.ofNullable(clazz.cast(this.dagProcessingLogs()));
            }
            case "SchedulerLogs": {
                return Optional.ofNullable(clazz.cast(this.schedulerLogs()));
            }
            case "TaskLogs": {
                return Optional.ofNullable(clazz.cast(this.taskLogs()));
            }
            case "WebserverLogs": {
                return Optional.ofNullable(clazz.cast(this.webserverLogs()));
            }
            case "WorkerLogs": {
                return Optional.ofNullable(clazz.cast(this.workerLogs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfigurationInput, T> g) {
        return obj -> g.apply((LoggingConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ModuleLoggingConfigurationInput dagProcessingLogs;
        private ModuleLoggingConfigurationInput schedulerLogs;
        private ModuleLoggingConfigurationInput taskLogs;
        private ModuleLoggingConfigurationInput webserverLogs;
        private ModuleLoggingConfigurationInput workerLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfigurationInput model) {
            this.dagProcessingLogs(model.dagProcessingLogs);
            this.schedulerLogs(model.schedulerLogs);
            this.taskLogs(model.taskLogs);
            this.webserverLogs(model.webserverLogs);
            this.workerLogs(model.workerLogs);
        }

        public final ModuleLoggingConfigurationInput.Builder getDagProcessingLogs() {
            return this.dagProcessingLogs != null ? this.dagProcessingLogs.toBuilder() : null;
        }

        @Override
        public final Builder dagProcessingLogs(ModuleLoggingConfigurationInput dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs;
            return this;
        }

        public final void setDagProcessingLogs(ModuleLoggingConfigurationInput.BuilderImpl dagProcessingLogs) {
            this.dagProcessingLogs = dagProcessingLogs != null ? dagProcessingLogs.build() : null;
        }

        public final ModuleLoggingConfigurationInput.Builder getSchedulerLogs() {
            return this.schedulerLogs != null ? this.schedulerLogs.toBuilder() : null;
        }

        @Override
        public final Builder schedulerLogs(ModuleLoggingConfigurationInput schedulerLogs) {
            this.schedulerLogs = schedulerLogs;
            return this;
        }

        public final void setSchedulerLogs(ModuleLoggingConfigurationInput.BuilderImpl schedulerLogs) {
            this.schedulerLogs = schedulerLogs != null ? schedulerLogs.build() : null;
        }

        public final ModuleLoggingConfigurationInput.Builder getTaskLogs() {
            return this.taskLogs != null ? this.taskLogs.toBuilder() : null;
        }

        @Override
        public final Builder taskLogs(ModuleLoggingConfigurationInput taskLogs) {
            this.taskLogs = taskLogs;
            return this;
        }

        public final void setTaskLogs(ModuleLoggingConfigurationInput.BuilderImpl taskLogs) {
            this.taskLogs = taskLogs != null ? taskLogs.build() : null;
        }

        public final ModuleLoggingConfigurationInput.Builder getWebserverLogs() {
            return this.webserverLogs != null ? this.webserverLogs.toBuilder() : null;
        }

        @Override
        public final Builder webserverLogs(ModuleLoggingConfigurationInput webserverLogs) {
            this.webserverLogs = webserverLogs;
            return this;
        }

        public final void setWebserverLogs(ModuleLoggingConfigurationInput.BuilderImpl webserverLogs) {
            this.webserverLogs = webserverLogs != null ? webserverLogs.build() : null;
        }

        public final ModuleLoggingConfigurationInput.Builder getWorkerLogs() {
            return this.workerLogs != null ? this.workerLogs.toBuilder() : null;
        }

        @Override
        public final Builder workerLogs(ModuleLoggingConfigurationInput workerLogs) {
            this.workerLogs = workerLogs;
            return this;
        }

        public final void setWorkerLogs(ModuleLoggingConfigurationInput.BuilderImpl workerLogs) {
            this.workerLogs = workerLogs != null ? workerLogs.build() : null;
        }

        public LoggingConfigurationInput build() {
            return new LoggingConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfigurationInput> {
        public Builder dagProcessingLogs(ModuleLoggingConfigurationInput var1);

        default public Builder dagProcessingLogs(Consumer<ModuleLoggingConfigurationInput.Builder> dagProcessingLogs) {
            return this.dagProcessingLogs((ModuleLoggingConfigurationInput)((ModuleLoggingConfigurationInput.Builder)ModuleLoggingConfigurationInput.builder().applyMutation(dagProcessingLogs)).build());
        }

        public Builder schedulerLogs(ModuleLoggingConfigurationInput var1);

        default public Builder schedulerLogs(Consumer<ModuleLoggingConfigurationInput.Builder> schedulerLogs) {
            return this.schedulerLogs((ModuleLoggingConfigurationInput)((ModuleLoggingConfigurationInput.Builder)ModuleLoggingConfigurationInput.builder().applyMutation(schedulerLogs)).build());
        }

        public Builder taskLogs(ModuleLoggingConfigurationInput var1);

        default public Builder taskLogs(Consumer<ModuleLoggingConfigurationInput.Builder> taskLogs) {
            return this.taskLogs((ModuleLoggingConfigurationInput)((ModuleLoggingConfigurationInput.Builder)ModuleLoggingConfigurationInput.builder().applyMutation(taskLogs)).build());
        }

        public Builder webserverLogs(ModuleLoggingConfigurationInput var1);

        default public Builder webserverLogs(Consumer<ModuleLoggingConfigurationInput.Builder> webserverLogs) {
            return this.webserverLogs((ModuleLoggingConfigurationInput)((ModuleLoggingConfigurationInput.Builder)ModuleLoggingConfigurationInput.builder().applyMutation(webserverLogs)).build());
        }

        public Builder workerLogs(ModuleLoggingConfigurationInput var1);

        default public Builder workerLogs(Consumer<ModuleLoggingConfigurationInput.Builder> workerLogs) {
            return this.workerLogs((ModuleLoggingConfigurationInput)((ModuleLoggingConfigurationInput.Builder)ModuleLoggingConfigurationInput.builder().applyMutation(workerLogs)).build());
        }
    }
}

