/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFiltersIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSourceServersRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::isArchived)).setter(DescribeSourceServersRequestFilters.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServerIDs").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::sourceServerIDs)).setter(DescribeSourceServersRequestFilters.setter(Builder::sourceServerIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_ARCHIVED_FIELD, SOURCE_SERVER_I_DS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean isArchived;
    private final List<String> sourceServerIDs;

    private DescribeSourceServersRequestFilters(BuilderImpl builder) {
        this.isArchived = builder.isArchived;
        this.sourceServerIDs = builder.sourceServerIDs;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final boolean hasSourceServerIDs() {
        return this.sourceServerIDs != null && !(this.sourceServerIDs instanceof SdkAutoConstructList);
    }

    public final List<String> sourceServerIDs() {
        return this.sourceServerIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServerIDs() ? this.sourceServerIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceServersRequestFilters)) {
            return false;
        }
        DescribeSourceServersRequestFilters other = (DescribeSourceServersRequestFilters)obj;
        return Objects.equals(this.isArchived(), other.isArchived()) && this.hasSourceServerIDs() == other.hasSourceServerIDs() && Objects.equals(this.sourceServerIDs(), other.sourceServerIDs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSourceServersRequestFilters").add("IsArchived", (Object)this.isArchived()).add("SourceServerIDs", this.hasSourceServerIDs() ? this.sourceServerIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "sourceServerIDs": {
                return Optional.ofNullable(clazz.cast(this.sourceServerIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceServersRequestFilters, T> g) {
        return obj -> g.apply((DescribeSourceServersRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isArchived;
        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceServersRequestFilters model) {
            this.isArchived(model.isArchived);
            this.sourceServerIDs(model.sourceServerIDs);
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        public final Collection<String> getSourceServerIDs() {
            if (this.sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceServerIDs;
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String ... sourceServerIDs) {
            this.sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
        }

        public DescribeSourceServersRequestFilters build() {
            return new DescribeSourceServersRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
        public Builder isArchived(Boolean var1);

        public Builder sourceServerIDs(Collection<String> var1);

        public Builder sourceServerIDs(String ... var1);
    }
}

