/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClient;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsRequest;
import software.amazon.awssdk.services.mediastoredata.model.ListItemsResponse;

public class ListItemsPublisher
implements SdkPublisher<ListItemsResponse> {
    private final MediaStoreDataAsyncClient client;
    private final ListItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListItemsPublisher(MediaStoreDataAsyncClient client, ListItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListItemsPublisher(MediaStoreDataAsyncClient client, ListItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListItemsResponseFetcher
    implements AsyncPageFetcher<ListItemsResponse> {
        private ListItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListItemsResponse> nextPage(ListItemsResponse previousPage) {
            if (previousPage == null) {
                return ListItemsPublisher.this.client.listItems(ListItemsPublisher.this.firstRequest);
            }
            return ListItemsPublisher.this.client.listItems((ListItemsRequest)((Object)ListItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

