/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagevod.model.ManifestLayout;
import software.amazon.awssdk.services.mediapackagevod.model.Profile;
import software.amazon.awssdk.services.mediapackagevod.model.StreamSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashManifest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashManifest> {
    private static final SdkField<String> MANIFEST_LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestLayout").getter(DashManifest.getter(DashManifest::manifestLayoutAsString)).setter(DashManifest.setter(Builder::manifestLayout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestLayout").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(DashManifest.getter(DashManifest::manifestName)).setter(DashManifest.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestName").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTimeSeconds").getter(DashManifest.getter(DashManifest::minBufferTimeSeconds)).setter(DashManifest.setter(Builder::minBufferTimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTimeSeconds").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(DashManifest.getter(DashManifest::profileAsString)).setter(DashManifest.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamSelection").getter(DashManifest.getter(DashManifest::streamSelection)).setter(DashManifest.setter(Builder::streamSelection)).constructor(StreamSelection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_LAYOUT_FIELD, MANIFEST_NAME_FIELD, MIN_BUFFER_TIME_SECONDS_FIELD, PROFILE_FIELD, STREAM_SELECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String manifestLayout;
    private final String manifestName;
    private final Integer minBufferTimeSeconds;
    private final String profile;
    private final StreamSelection streamSelection;

    private DashManifest(BuilderImpl builder) {
        this.manifestLayout = builder.manifestLayout;
        this.manifestName = builder.manifestName;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.profile = builder.profile;
        this.streamSelection = builder.streamSelection;
    }

    public final ManifestLayout manifestLayout() {
        return ManifestLayout.fromValue(this.manifestLayout);
    }

    public final String manifestLayoutAsString() {
        return this.manifestLayout;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final Integer minBufferTimeSeconds() {
        return this.minBufferTimeSeconds;
    }

    public final Profile profile() {
        return Profile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public final StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestLayoutAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashManifest)) {
            return false;
        }
        DashManifest other = (DashManifest)obj;
        return Objects.equals(this.manifestLayoutAsString(), other.manifestLayoutAsString()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.minBufferTimeSeconds(), other.minBufferTimeSeconds()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.streamSelection(), other.streamSelection());
    }

    public final String toString() {
        return ToString.builder((String)"DashManifest").add("ManifestLayout", (Object)this.manifestLayoutAsString()).add("ManifestName", (Object)this.manifestName()).add("MinBufferTimeSeconds", (Object)this.minBufferTimeSeconds()).add("Profile", (Object)this.profileAsString()).add("StreamSelection", (Object)this.streamSelection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManifestLayout": {
                return Optional.ofNullable(clazz.cast(this.manifestLayoutAsString()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "MinBufferTimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.minBufferTimeSeconds()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "StreamSelection": {
                return Optional.ofNullable(clazz.cast(this.streamSelection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashManifest, T> g) {
        return obj -> g.apply((DashManifest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String manifestLayout;
        private String manifestName;
        private Integer minBufferTimeSeconds;
        private String profile;
        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(DashManifest model) {
            this.manifestLayout(model.manifestLayout);
            this.manifestName(model.manifestName);
            this.minBufferTimeSeconds(model.minBufferTimeSeconds);
            this.profile(model.profile);
            this.streamSelection(model.streamSelection);
        }

        public final String getManifestLayout() {
            return this.manifestLayout;
        }

        @Override
        public final Builder manifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
            return this;
        }

        @Override
        public final Builder manifestLayout(ManifestLayout manifestLayout) {
            this.manifestLayout(manifestLayout == null ? null : manifestLayout.toString());
            return this;
        }

        public final void setManifestLayout(String manifestLayout) {
            this.manifestLayout = manifestLayout;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        public final Integer getMinBufferTimeSeconds() {
            return this.minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        public final String getProfile() {
            return this.profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public DashManifest build() {
            return new DashManifest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashManifest> {
        public Builder manifestLayout(String var1);

        public Builder manifestLayout(ManifestLayout var1);

        public Builder manifestName(String var1);

        public Builder minBufferTimeSeconds(Integer var1);

        public Builder profile(String var1);

        public Builder profile(Profile var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().applyMutation(streamSelection)).build());
        }
    }
}

