/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum InputCodec {
    MPEG2("MPEG2"),
    AVC("AVC"),
    HEVC("HEVC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private InputCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(InputCodec.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputCodec> knownValues() {
        return Stream.of(InputCodec.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

