/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.BatchScheduleActionCreateRequest;
import software.amazon.awssdk.services.medialive.model.BatchScheduleActionDeleteRequest;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateScheduleRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, BatchUpdateScheduleRequest> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(BatchUpdateScheduleRequest.getter(BatchUpdateScheduleRequest::channelId)).setter(BatchUpdateScheduleRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<BatchScheduleActionCreateRequest> CREATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Creates").getter(BatchUpdateScheduleRequest.getter(BatchUpdateScheduleRequest::creates)).setter(BatchUpdateScheduleRequest.setter(Builder::creates)).constructor(BatchScheduleActionCreateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creates").build()}).build();
    private static final SdkField<BatchScheduleActionDeleteRequest> DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Deletes").getter(BatchUpdateScheduleRequest.getter(BatchUpdateScheduleRequest::deletes)).setter(BatchUpdateScheduleRequest.setter(Builder::deletes)).constructor(BatchScheduleActionDeleteRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, CREATES_FIELD, DELETES_FIELD));
    private final String channelId;
    private final BatchScheduleActionCreateRequest creates;
    private final BatchScheduleActionDeleteRequest deletes;

    private BatchUpdateScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.channelId = builder.channelId;
        this.creates = builder.creates;
        this.deletes = builder.deletes;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final BatchScheduleActionCreateRequest creates() {
        return this.creates;
    }

    public final BatchScheduleActionDeleteRequest deletes() {
        return this.deletes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creates());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateScheduleRequest)) {
            return false;
        }
        BatchUpdateScheduleRequest other = (BatchUpdateScheduleRequest)((Object)obj);
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.creates(), other.creates()) && Objects.equals(this.deletes(), other.deletes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateScheduleRequest").add("ChannelId", (Object)this.channelId()).add("Creates", (Object)this.creates()).add("Deletes", (Object)this.deletes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "Creates": {
                return Optional.ofNullable(clazz.cast(this.creates()));
            }
            case "Deletes": {
                return Optional.ofNullable(clazz.cast(this.deletes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateScheduleRequest, T> g) {
        return obj -> g.apply((BatchUpdateScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelId;
        private BatchScheduleActionCreateRequest creates;
        private BatchScheduleActionDeleteRequest deletes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateScheduleRequest model) {
            super(model);
            this.channelId(model.channelId);
            this.creates(model.creates);
            this.deletes(model.deletes);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public final BatchScheduleActionCreateRequest.Builder getCreates() {
            return this.creates != null ? this.creates.toBuilder() : null;
        }

        @Override
        public final Builder creates(BatchScheduleActionCreateRequest creates) {
            this.creates = creates;
            return this;
        }

        public final void setCreates(BatchScheduleActionCreateRequest.BuilderImpl creates) {
            this.creates = creates != null ? creates.build() : null;
        }

        public final BatchScheduleActionDeleteRequest.Builder getDeletes() {
            return this.deletes != null ? this.deletes.toBuilder() : null;
        }

        @Override
        public final Builder deletes(BatchScheduleActionDeleteRequest deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(BatchScheduleActionDeleteRequest.BuilderImpl deletes) {
            this.deletes = deletes != null ? deletes.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateScheduleRequest build() {
            return new BatchUpdateScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateScheduleRequest> {
        public Builder channelId(String var1);

        public Builder creates(BatchScheduleActionCreateRequest var1);

        default public Builder creates(Consumer<BatchScheduleActionCreateRequest.Builder> creates) {
            return this.creates((BatchScheduleActionCreateRequest)((BatchScheduleActionCreateRequest.Builder)BatchScheduleActionCreateRequest.builder().applyMutation(creates)).build());
        }

        public Builder deletes(BatchScheduleActionDeleteRequest var1);

        default public Builder deletes(Consumer<BatchScheduleActionDeleteRequest.Builder> deletes) {
            return this.deletes((BatchScheduleActionDeleteRequest)((BatchScheduleActionDeleteRequest.Builder)BatchScheduleActionDeleteRequest.builder().applyMutation(deletes)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

