/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ArchiveCdnSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArchiveGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArchiveGroupSettings> {
    private static final SdkField<ArchiveCdnSettings> ARCHIVE_CDN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ArchiveCdnSettings").getter(ArchiveGroupSettings.getter(ArchiveGroupSettings::archiveCdnSettings)).setter(ArchiveGroupSettings.setter(Builder::archiveCdnSettings)).constructor(ArchiveCdnSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveCdnSettings").build()}).build();
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(ArchiveGroupSettings.getter(ArchiveGroupSettings::destination)).setter(ArchiveGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> ROLLOVER_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RolloverInterval").getter(ArchiveGroupSettings.getter(ArchiveGroupSettings::rolloverInterval)).setter(ArchiveGroupSettings.setter(Builder::rolloverInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rolloverInterval").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_CDN_SETTINGS_FIELD, DESTINATION_FIELD, ROLLOVER_INTERVAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final ArchiveCdnSettings archiveCdnSettings;
    private final OutputLocationRef destination;
    private final Integer rolloverInterval;

    private ArchiveGroupSettings(BuilderImpl builder) {
        this.archiveCdnSettings = builder.archiveCdnSettings;
        this.destination = builder.destination;
        this.rolloverInterval = builder.rolloverInterval;
    }

    public final ArchiveCdnSettings archiveCdnSettings() {
        return this.archiveCdnSettings;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final Integer rolloverInterval() {
        return this.rolloverInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.archiveCdnSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.rolloverInterval());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveGroupSettings)) {
            return false;
        }
        ArchiveGroupSettings other = (ArchiveGroupSettings)obj;
        return Objects.equals(this.archiveCdnSettings(), other.archiveCdnSettings()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.rolloverInterval(), other.rolloverInterval());
    }

    public final String toString() {
        return ToString.builder((String)"ArchiveGroupSettings").add("ArchiveCdnSettings", (Object)this.archiveCdnSettings()).add("Destination", (Object)this.destination()).add("RolloverInterval", (Object)this.rolloverInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchiveCdnSettings": {
                return Optional.ofNullable(clazz.cast(this.archiveCdnSettings()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "RolloverInterval": {
                return Optional.ofNullable(clazz.cast(this.rolloverInterval()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveGroupSettings, T> g) {
        return obj -> g.apply((ArchiveGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ArchiveCdnSettings archiveCdnSettings;
        private OutputLocationRef destination;
        private Integer rolloverInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveGroupSettings model) {
            this.archiveCdnSettings(model.archiveCdnSettings);
            this.destination(model.destination);
            this.rolloverInterval(model.rolloverInterval);
        }

        public final ArchiveCdnSettings.Builder getArchiveCdnSettings() {
            return this.archiveCdnSettings != null ? this.archiveCdnSettings.toBuilder() : null;
        }

        @Override
        public final Builder archiveCdnSettings(ArchiveCdnSettings archiveCdnSettings) {
            this.archiveCdnSettings = archiveCdnSettings;
            return this;
        }

        public final void setArchiveCdnSettings(ArchiveCdnSettings.BuilderImpl archiveCdnSettings) {
            this.archiveCdnSettings = archiveCdnSettings != null ? archiveCdnSettings.build() : null;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Integer getRolloverInterval() {
            return this.rolloverInterval;
        }

        @Override
        public final Builder rolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
            return this;
        }

        public final void setRolloverInterval(Integer rolloverInterval) {
            this.rolloverInterval = rolloverInterval;
        }

        public ArchiveGroupSettings build() {
            return new ArchiveGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArchiveGroupSettings> {
        public Builder archiveCdnSettings(ArchiveCdnSettings var1);

        default public Builder archiveCdnSettings(Consumer<ArchiveCdnSettings.Builder> archiveCdnSettings) {
            return this.archiveCdnSettings((ArchiveCdnSettings)((ArchiveCdnSettings.Builder)ArchiveCdnSettings.builder().applyMutation(archiveCdnSettings)).build());
        }

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder rolloverInterval(Integer var1);
    }
}

