/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ChannelMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemixSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemixSettings> {
    private static final SdkField<ChannelMapping> CHANNEL_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChannelMapping").getter(RemixSettings.getter(RemixSettings::channelMapping)).setter(RemixSettings.setter(Builder::channelMapping)).constructor(ChannelMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMapping").build()}).build();
    private static final SdkField<Integer> CHANNELS_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelsIn").getter(RemixSettings.getter(RemixSettings::channelsIn)).setter(RemixSettings.setter(Builder::channelsIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsIn").build()}).build();
    private static final SdkField<Integer> CHANNELS_OUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelsOut").getter(RemixSettings.getter(RemixSettings::channelsOut)).setter(RemixSettings.setter(Builder::channelsOut)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsOut").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MAPPING_FIELD, CHANNELS_IN_FIELD, CHANNELS_OUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final ChannelMapping channelMapping;
    private final Integer channelsIn;
    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.channelMapping = builder.channelMapping;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    public final ChannelMapping channelMapping() {
        return this.channelMapping;
    }

    public final Integer channelsIn() {
        return this.channelsIn;
    }

    public final Integer channelsOut() {
        return this.channelsOut;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsOut());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings)obj;
        return Objects.equals(this.channelMapping(), other.channelMapping()) && Objects.equals(this.channelsIn(), other.channelsIn()) && Objects.equals(this.channelsOut(), other.channelsOut());
    }

    public final String toString() {
        return ToString.builder((String)"RemixSettings").add("ChannelMapping", (Object)this.channelMapping()).add("ChannelsIn", (Object)this.channelsIn()).add("ChannelsOut", (Object)this.channelsOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelMapping": {
                return Optional.ofNullable(clazz.cast(this.channelMapping()));
            }
            case "ChannelsIn": {
                return Optional.ofNullable(clazz.cast(this.channelsIn()));
            }
            case "ChannelsOut": {
                return Optional.ofNullable(clazz.cast(this.channelsOut()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemixSettings, T> g) {
        return obj -> g.apply((RemixSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ChannelMapping channelMapping;
        private Integer channelsIn;
        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            this.channelMapping(model.channelMapping);
            this.channelsIn(model.channelsIn);
            this.channelsOut(model.channelsOut);
        }

        public final ChannelMapping.Builder getChannelMapping() {
            return this.channelMapping != null ? this.channelMapping.toBuilder() : null;
        }

        @Override
        public final Builder channelMapping(ChannelMapping channelMapping) {
            this.channelMapping = channelMapping;
            return this;
        }

        public final void setChannelMapping(ChannelMapping.BuilderImpl channelMapping) {
            this.channelMapping = channelMapping != null ? channelMapping.build() : null;
        }

        public final Integer getChannelsIn() {
            return this.channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        public final Integer getChannelsOut() {
            return this.channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        public RemixSettings build() {
            return new RemixSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemixSettings> {
        public Builder channelMapping(ChannelMapping var1);

        default public Builder channelMapping(Consumer<ChannelMapping.Builder> channelMapping) {
            return this.channelMapping((ChannelMapping)((ChannelMapping.Builder)ChannelMapping.builder().applyMutation(channelMapping)).build());
        }

        public Builder channelsIn(Integer var1);

        public Builder channelsOut(Integer var1);
    }
}

