/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__doubleMinNegative60Max6Copier;
import software.amazon.awssdk.services.mediaconvert.model.___listOf__integerMinNegative60Max6Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputChannelMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputChannelMapping> {
    private static final SdkField<List<Integer>> INPUT_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputChannels").getter(OutputChannelMapping.getter(OutputChannelMapping::inputChannels)).setter(OutputChannelMapping.setter(Builder::inputChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> INPUT_CHANNELS_FINE_TUNE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputChannelsFineTune").getter(OutputChannelMapping.getter(OutputChannelMapping::inputChannelsFineTune)).setter(OutputChannelMapping.setter(Builder::inputChannelsFineTune)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputChannelsFineTune").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_CHANNELS_FIELD, INPUT_CHANNELS_FINE_TUNE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Integer> inputChannels;
    private final List<Double> inputChannelsFineTune;

    private OutputChannelMapping(BuilderImpl builder) {
        this.inputChannels = builder.inputChannels;
        this.inputChannelsFineTune = builder.inputChannelsFineTune;
    }

    public final boolean hasInputChannels() {
        return this.inputChannels != null && !(this.inputChannels instanceof SdkAutoConstructList);
    }

    public final List<Integer> inputChannels() {
        return this.inputChannels;
    }

    public final boolean hasInputChannelsFineTune() {
        return this.inputChannelsFineTune != null && !(this.inputChannelsFineTune instanceof SdkAutoConstructList);
    }

    public final List<Double> inputChannelsFineTune() {
        return this.inputChannelsFineTune;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputChannels() ? this.inputChannels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputChannelsFineTune() ? this.inputChannelsFineTune() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputChannelMapping)) {
            return false;
        }
        OutputChannelMapping other = (OutputChannelMapping)obj;
        return this.hasInputChannels() == other.hasInputChannels() && Objects.equals(this.inputChannels(), other.inputChannels()) && this.hasInputChannelsFineTune() == other.hasInputChannelsFineTune() && Objects.equals(this.inputChannelsFineTune(), other.inputChannelsFineTune());
    }

    public final String toString() {
        return ToString.builder((String)"OutputChannelMapping").add("InputChannels", this.hasInputChannels() ? this.inputChannels() : null).add("InputChannelsFineTune", this.hasInputChannelsFineTune() ? this.inputChannelsFineTune() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputChannels": {
                return Optional.ofNullable(clazz.cast(this.inputChannels()));
            }
            case "InputChannelsFineTune": {
                return Optional.ofNullable(clazz.cast(this.inputChannelsFineTune()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputChannelMapping, T> g) {
        return obj -> g.apply((OutputChannelMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Integer> inputChannels = DefaultSdkAutoConstructList.getInstance();
        private List<Double> inputChannelsFineTune = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputChannelMapping model) {
            this.inputChannels(model.inputChannels);
            this.inputChannelsFineTune(model.inputChannelsFineTune);
        }

        public final Collection<Integer> getInputChannels() {
            if (this.inputChannels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputChannels;
        }

        @Override
        public final Builder inputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ___listOf__integerMinNegative60Max6Copier.copy(inputChannels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannels(Integer ... inputChannels) {
            this.inputChannels(Arrays.asList(inputChannels));
            return this;
        }

        public final void setInputChannels(Collection<Integer> inputChannels) {
            this.inputChannels = ___listOf__integerMinNegative60Max6Copier.copy(inputChannels);
        }

        public final Collection<Double> getInputChannelsFineTune() {
            if (this.inputChannelsFineTune instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputChannelsFineTune;
        }

        @Override
        public final Builder inputChannelsFineTune(Collection<Double> inputChannelsFineTune) {
            this.inputChannelsFineTune = ___listOf__doubleMinNegative60Max6Copier.copy(inputChannelsFineTune);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputChannelsFineTune(Double ... inputChannelsFineTune) {
            this.inputChannelsFineTune(Arrays.asList(inputChannelsFineTune));
            return this;
        }

        public final void setInputChannelsFineTune(Collection<Double> inputChannelsFineTune) {
            this.inputChannelsFineTune = ___listOf__doubleMinNegative60Max6Copier.copy(inputChannelsFineTune);
        }

        public OutputChannelMapping build() {
            return new OutputChannelMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputChannelMapping> {
        public Builder inputChannels(Collection<Integer> var1);

        public Builder inputChannels(Integer ... var1);

        public Builder inputChannelsFineTune(Collection<Double> var1);

        public Builder inputChannelsFineTune(Double ... var1);
    }
}

