/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContainerType {
    F4_V("F4V"),
    ISMV("ISMV"),
    M2_TS("M2TS"),
    M3_U8("M3U8"),
    CMFC("CMFC"),
    MOV("MOV"),
    MP4("MP4"),
    MPD("MPD"),
    MXF("MXF"),
    WEBM("WEBM"),
    RAW("RAW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContainerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContainerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerType> knownValues() {
        return Stream.of(ContainerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

