/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CSVFileCompression {
    NONE("NONE"),
    GZIP("GZIP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CSVFileCompression(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CSVFileCompression fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CSVFileCompression.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CSVFileCompression> knownValues() {
        return Stream.of(CSVFileCompression.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

