/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.AlarmState;
import software.amazon.awssdk.services.lightsail.model.ComparisonOperator;
import software.amazon.awssdk.services.lightsail.model.ContactProtocol;
import software.amazon.awssdk.services.lightsail.model.ContactProtocolsListCopier;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.services.lightsail.model.MetricName;
import software.amazon.awssdk.services.lightsail.model.NotificationTriggerListCopier;
import software.amazon.awssdk.services.lightsail.model.TreatMissingData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAlarmRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, PutAlarmRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmName").getter(PutAlarmRequest.getter(PutAlarmRequest::alarmName)).setter(PutAlarmRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmName").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(PutAlarmRequest.getter(PutAlarmRequest::metricNameAsString)).setter(PutAlarmRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> MONITORED_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitoredResourceName").getter(PutAlarmRequest.getter(PutAlarmRequest::monitoredResourceName)).setter(PutAlarmRequest.setter(Builder::monitoredResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoredResourceName").build()}).build();
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comparisonOperator").getter(PutAlarmRequest.getter(PutAlarmRequest::comparisonOperatorAsString)).setter(PutAlarmRequest.setter(Builder::comparisonOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOperator").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("threshold").getter(PutAlarmRequest.getter(PutAlarmRequest::threshold)).setter(PutAlarmRequest.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final SdkField<Integer> EVALUATION_PERIODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("evaluationPeriods").getter(PutAlarmRequest.getter(PutAlarmRequest::evaluationPeriods)).setter(PutAlarmRequest.setter(Builder::evaluationPeriods)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationPeriods").build()}).build();
    private static final SdkField<Integer> DATAPOINTS_TO_ALARM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("datapointsToAlarm").getter(PutAlarmRequest.getter(PutAlarmRequest::datapointsToAlarm)).setter(PutAlarmRequest.setter(Builder::datapointsToAlarm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datapointsToAlarm").build()}).build();
    private static final SdkField<String> TREAT_MISSING_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treatMissingData").getter(PutAlarmRequest.getter(PutAlarmRequest::treatMissingDataAsString)).setter(PutAlarmRequest.setter(Builder::treatMissingData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatMissingData").build()}).build();
    private static final SdkField<List<String>> CONTACT_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contactProtocols").getter(PutAlarmRequest.getter(PutAlarmRequest::contactProtocolsAsStrings)).setter(PutAlarmRequest.setter(Builder::contactProtocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactProtocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationTriggers").getter(PutAlarmRequest.getter(PutAlarmRequest::notificationTriggersAsStrings)).setter(PutAlarmRequest.setter(Builder::notificationTriggersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationTriggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NOTIFICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("notificationEnabled").getter(PutAlarmRequest.getter(PutAlarmRequest::notificationEnabled)).setter(PutAlarmRequest.setter(Builder::notificationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, METRIC_NAME_FIELD, MONITORED_RESOURCE_NAME_FIELD, COMPARISON_OPERATOR_FIELD, THRESHOLD_FIELD, EVALUATION_PERIODS_FIELD, DATAPOINTS_TO_ALARM_FIELD, TREAT_MISSING_DATA_FIELD, CONTACT_PROTOCOLS_FIELD, NOTIFICATION_TRIGGERS_FIELD, NOTIFICATION_ENABLED_FIELD));
    private final String alarmName;
    private final String metricName;
    private final String monitoredResourceName;
    private final String comparisonOperator;
    private final Double threshold;
    private final Integer evaluationPeriods;
    private final Integer datapointsToAlarm;
    private final String treatMissingData;
    private final List<String> contactProtocols;
    private final List<String> notificationTriggers;
    private final Boolean notificationEnabled;

    private PutAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.metricName = builder.metricName;
        this.monitoredResourceName = builder.monitoredResourceName;
        this.comparisonOperator = builder.comparisonOperator;
        this.threshold = builder.threshold;
        this.evaluationPeriods = builder.evaluationPeriods;
        this.datapointsToAlarm = builder.datapointsToAlarm;
        this.treatMissingData = builder.treatMissingData;
        this.contactProtocols = builder.contactProtocols;
        this.notificationTriggers = builder.notificationTriggers;
        this.notificationEnabled = builder.notificationEnabled;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final MetricName metricName() {
        return MetricName.fromValue(this.metricName);
    }

    public final String metricNameAsString() {
        return this.metricName;
    }

    public final String monitoredResourceName() {
        return this.monitoredResourceName;
    }

    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(this.comparisonOperator);
    }

    public final String comparisonOperatorAsString() {
        return this.comparisonOperator;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public final Integer evaluationPeriods() {
        return this.evaluationPeriods;
    }

    public final Integer datapointsToAlarm() {
        return this.datapointsToAlarm;
    }

    public final TreatMissingData treatMissingData() {
        return TreatMissingData.fromValue(this.treatMissingData);
    }

    public final String treatMissingDataAsString() {
        return this.treatMissingData;
    }

    public final List<ContactProtocol> contactProtocols() {
        return ContactProtocolsListCopier.copyStringToEnum(this.contactProtocols);
    }

    public final boolean hasContactProtocols() {
        return this.contactProtocols != null && !(this.contactProtocols instanceof SdkAutoConstructList);
    }

    public final List<String> contactProtocolsAsStrings() {
        return this.contactProtocols;
    }

    public final List<AlarmState> notificationTriggers() {
        return NotificationTriggerListCopier.copyStringToEnum(this.notificationTriggers);
    }

    public final boolean hasNotificationTriggers() {
        return this.notificationTriggers != null && !(this.notificationTriggers instanceof SdkAutoConstructList);
    }

    public final List<String> notificationTriggersAsStrings() {
        return this.notificationTriggers;
    }

    public final Boolean notificationEnabled() {
        return this.notificationEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoredResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationPeriods());
        hashCode = 31 * hashCode + Objects.hashCode(this.datapointsToAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatMissingDataAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactProtocols() ? this.contactProtocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationTriggers() ? this.notificationTriggersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAlarmRequest)) {
            return false;
        }
        PutAlarmRequest other = (PutAlarmRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.metricNameAsString(), other.metricNameAsString()) && Objects.equals(this.monitoredResourceName(), other.monitoredResourceName()) && Objects.equals(this.comparisonOperatorAsString(), other.comparisonOperatorAsString()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.evaluationPeriods(), other.evaluationPeriods()) && Objects.equals(this.datapointsToAlarm(), other.datapointsToAlarm()) && Objects.equals(this.treatMissingDataAsString(), other.treatMissingDataAsString()) && this.hasContactProtocols() == other.hasContactProtocols() && Objects.equals(this.contactProtocolsAsStrings(), other.contactProtocolsAsStrings()) && this.hasNotificationTriggers() == other.hasNotificationTriggers() && Objects.equals(this.notificationTriggersAsStrings(), other.notificationTriggersAsStrings()) && Objects.equals(this.notificationEnabled(), other.notificationEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"PutAlarmRequest").add("AlarmName", (Object)this.alarmName()).add("MetricName", (Object)this.metricNameAsString()).add("MonitoredResourceName", (Object)this.monitoredResourceName()).add("ComparisonOperator", (Object)this.comparisonOperatorAsString()).add("Threshold", (Object)this.threshold()).add("EvaluationPeriods", (Object)this.evaluationPeriods()).add("DatapointsToAlarm", (Object)this.datapointsToAlarm()).add("TreatMissingData", (Object)this.treatMissingDataAsString()).add("ContactProtocols", this.hasContactProtocols() ? this.contactProtocolsAsStrings() : null).add("NotificationTriggers", this.hasNotificationTriggers() ? this.notificationTriggersAsStrings() : null).add("NotificationEnabled", (Object)this.notificationEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricNameAsString()));
            }
            case "monitoredResourceName": {
                return Optional.ofNullable(clazz.cast(this.monitoredResourceName()));
            }
            case "comparisonOperator": {
                return Optional.ofNullable(clazz.cast(this.comparisonOperatorAsString()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "evaluationPeriods": {
                return Optional.ofNullable(clazz.cast(this.evaluationPeriods()));
            }
            case "datapointsToAlarm": {
                return Optional.ofNullable(clazz.cast(this.datapointsToAlarm()));
            }
            case "treatMissingData": {
                return Optional.ofNullable(clazz.cast(this.treatMissingDataAsString()));
            }
            case "contactProtocols": {
                return Optional.ofNullable(clazz.cast(this.contactProtocolsAsStrings()));
            }
            case "notificationTriggers": {
                return Optional.ofNullable(clazz.cast(this.notificationTriggersAsStrings()));
            }
            case "notificationEnabled": {
                return Optional.ofNullable(clazz.cast(this.notificationEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAlarmRequest, T> g) {
        return obj -> g.apply((PutAlarmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String metricName;
        private String monitoredResourceName;
        private String comparisonOperator;
        private Double threshold;
        private Integer evaluationPeriods;
        private Integer datapointsToAlarm;
        private String treatMissingData;
        private List<String> contactProtocols = DefaultSdkAutoConstructList.getInstance();
        private List<String> notificationTriggers = DefaultSdkAutoConstructList.getInstance();
        private Boolean notificationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAlarmRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.metricName(model.metricName);
            this.monitoredResourceName(model.monitoredResourceName);
            this.comparisonOperator(model.comparisonOperator);
            this.threshold(model.threshold);
            this.evaluationPeriods(model.evaluationPeriods);
            this.datapointsToAlarm(model.datapointsToAlarm);
            this.treatMissingData(model.treatMissingData);
            this.contactProtocolsWithStrings(model.contactProtocols);
            this.notificationTriggersWithStrings(model.notificationTriggers);
            this.notificationEnabled(model.notificationEnabled);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        @Override
        public final Builder metricName(MetricName metricName) {
            this.metricName(metricName == null ? null : metricName.toString());
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMonitoredResourceName() {
            return this.monitoredResourceName;
        }

        @Override
        public final Builder monitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        public final void setMonitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
        }

        public final String getComparisonOperator() {
            return this.comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final Integer getEvaluationPeriods() {
            return this.evaluationPeriods;
        }

        @Override
        public final Builder evaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
            return this;
        }

        public final void setEvaluationPeriods(Integer evaluationPeriods) {
            this.evaluationPeriods = evaluationPeriods;
        }

        public final Integer getDatapointsToAlarm() {
            return this.datapointsToAlarm;
        }

        @Override
        public final Builder datapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
            return this;
        }

        public final void setDatapointsToAlarm(Integer datapointsToAlarm) {
            this.datapointsToAlarm = datapointsToAlarm;
        }

        public final String getTreatMissingData() {
            return this.treatMissingData;
        }

        @Override
        public final Builder treatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
            return this;
        }

        @Override
        public final Builder treatMissingData(TreatMissingData treatMissingData) {
            this.treatMissingData(treatMissingData == null ? null : treatMissingData.toString());
            return this;
        }

        public final void setTreatMissingData(String treatMissingData) {
            this.treatMissingData = treatMissingData;
        }

        public final Collection<String> getContactProtocols() {
            if (this.contactProtocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactProtocols;
        }

        @Override
        public final Builder contactProtocolsWithStrings(Collection<String> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copy(contactProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactProtocolsWithStrings(String ... contactProtocols) {
            this.contactProtocolsWithStrings(Arrays.asList(contactProtocols));
            return this;
        }

        @Override
        public final Builder contactProtocols(Collection<ContactProtocol> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copyEnumToString(contactProtocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactProtocols(ContactProtocol ... contactProtocols) {
            this.contactProtocols(Arrays.asList(contactProtocols));
            return this;
        }

        public final void setContactProtocols(Collection<String> contactProtocols) {
            this.contactProtocols = ContactProtocolsListCopier.copy(contactProtocols);
        }

        public final Collection<String> getNotificationTriggers() {
            if (this.notificationTriggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notificationTriggers;
        }

        @Override
        public final Builder notificationTriggersWithStrings(Collection<String> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copy(notificationTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTriggersWithStrings(String ... notificationTriggers) {
            this.notificationTriggersWithStrings(Arrays.asList(notificationTriggers));
            return this;
        }

        @Override
        public final Builder notificationTriggers(Collection<AlarmState> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copyEnumToString(notificationTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationTriggers(AlarmState ... notificationTriggers) {
            this.notificationTriggers(Arrays.asList(notificationTriggers));
            return this;
        }

        public final void setNotificationTriggers(Collection<String> notificationTriggers) {
            this.notificationTriggers = NotificationTriggerListCopier.copy(notificationTriggers);
        }

        public final Boolean getNotificationEnabled() {
            return this.notificationEnabled;
        }

        @Override
        public final Builder notificationEnabled(Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
            return this;
        }

        public final void setNotificationEnabled(Boolean notificationEnabled) {
            this.notificationEnabled = notificationEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAlarmRequest build() {
            return new PutAlarmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAlarmRequest> {
        public Builder alarmName(String var1);

        public Builder metricName(String var1);

        public Builder metricName(MetricName var1);

        public Builder monitoredResourceName(String var1);

        public Builder comparisonOperator(String var1);

        public Builder comparisonOperator(ComparisonOperator var1);

        public Builder threshold(Double var1);

        public Builder evaluationPeriods(Integer var1);

        public Builder datapointsToAlarm(Integer var1);

        public Builder treatMissingData(String var1);

        public Builder treatMissingData(TreatMissingData var1);

        public Builder contactProtocolsWithStrings(Collection<String> var1);

        public Builder contactProtocolsWithStrings(String ... var1);

        public Builder contactProtocols(Collection<ContactProtocol> var1);

        public Builder contactProtocols(ContactProtocol ... var1);

        public Builder notificationTriggersWithStrings(Collection<String> var1);

        public Builder notificationTriggersWithStrings(String ... var1);

        public Builder notificationTriggers(Collection<AlarmState> var1);

        public Builder notificationTriggers(AlarmState ... var1);

        public Builder notificationEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

