/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecord;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationRecordListCopier;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateFailureReason;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRevocationReason;
import software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.services.lightsail.model.StringListCopier;
import software.amazon.awssdk.services.lightsail.model.Tag;
import software.amazon.awssdk.services.lightsail.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerTlsCertificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerTlsCertificate> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::name)).setter(LoadBalancerTlsCertificate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::arn)).setter(LoadBalancerTlsCertificate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SUPPORT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("supportCode").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::supportCode)).setter(LoadBalancerTlsCertificate.setter(Builder::supportCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportCode").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::createdAt)).setter(LoadBalancerTlsCertificate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::location)).setter(LoadBalancerTlsCertificate.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::resourceTypeAsString)).setter(LoadBalancerTlsCertificate.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::tags)).setter(LoadBalancerTlsCertificate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loadBalancerName").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::loadBalancerName)).setter(LoadBalancerTlsCertificate.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerName").build()}).build();
    private static final SdkField<Boolean> IS_ATTACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAttached").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::isAttached)).setter(LoadBalancerTlsCertificate.setter(Builder::isAttached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAttached").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::statusAsString)).setter(LoadBalancerTlsCertificate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::domainName)).setter(LoadBalancerTlsCertificate.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<LoadBalancerTlsCertificateDomainValidationRecord>> DOMAIN_VALIDATION_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("domainValidationRecords").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::domainValidationRecords)).setter(LoadBalancerTlsCertificate.setter(Builder::domainValidationRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainValidationRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerTlsCertificateDomainValidationRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::failureReasonAsString)).setter(LoadBalancerTlsCertificate.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Instant> ISSUED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("issuedAt").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::issuedAt)).setter(LoadBalancerTlsCertificate.setter(Builder::issuedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuedAt").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::issuer)).setter(LoadBalancerTlsCertificate.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<String> KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyAlgorithm").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::keyAlgorithm)).setter(LoadBalancerTlsCertificate.setter(Builder::keyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyAlgorithm").build()}).build();
    private static final SdkField<Instant> NOT_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notAfter").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::notAfter)).setter(LoadBalancerTlsCertificate.setter(Builder::notAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notAfter").build()}).build();
    private static final SdkField<Instant> NOT_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notBefore").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::notBefore)).setter(LoadBalancerTlsCertificate.setter(Builder::notBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notBefore").build()}).build();
    private static final SdkField<LoadBalancerTlsCertificateRenewalSummary> RENEWAL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renewalSummary").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::renewalSummary)).setter(LoadBalancerTlsCertificate.setter(Builder::renewalSummary)).constructor(LoadBalancerTlsCertificateRenewalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renewalSummary").build()}).build();
    private static final SdkField<String> REVOCATION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revocationReason").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::revocationReasonAsString)).setter(LoadBalancerTlsCertificate.setter(Builder::revocationReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revocationReason").build()}).build();
    private static final SdkField<Instant> REVOKED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("revokedAt").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::revokedAt)).setter(LoadBalancerTlsCertificate.setter(Builder::revokedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revokedAt").build()}).build();
    private static final SdkField<String> SERIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serial").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::serial)).setter(LoadBalancerTlsCertificate.setter(Builder::serial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serial").build()}).build();
    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureAlgorithm").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::signatureAlgorithm)).setter(LoadBalancerTlsCertificate.setter(Builder::signatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureAlgorithm").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::subject)).setter(LoadBalancerTlsCertificate.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<List<String>> SUBJECT_ALTERNATIVE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subjectAlternativeNames").getter(LoadBalancerTlsCertificate.getter(LoadBalancerTlsCertificate::subjectAlternativeNames)).setter(LoadBalancerTlsCertificate.setter(Builder::subjectAlternativeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectAlternativeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, SUPPORT_CODE_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, TAGS_FIELD, LOAD_BALANCER_NAME_FIELD, IS_ATTACHED_FIELD, STATUS_FIELD, DOMAIN_NAME_FIELD, DOMAIN_VALIDATION_RECORDS_FIELD, FAILURE_REASON_FIELD, ISSUED_AT_FIELD, ISSUER_FIELD, KEY_ALGORITHM_FIELD, NOT_AFTER_FIELD, NOT_BEFORE_FIELD, RENEWAL_SUMMARY_FIELD, REVOCATION_REASON_FIELD, REVOKED_AT_FIELD, SERIAL_FIELD, SIGNATURE_ALGORITHM_FIELD, SUBJECT_FIELD, SUBJECT_ALTERNATIVE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String supportCode;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final List<Tag> tags;
    private final String loadBalancerName;
    private final Boolean isAttached;
    private final String status;
    private final String domainName;
    private final List<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords;
    private final String failureReason;
    private final Instant issuedAt;
    private final String issuer;
    private final String keyAlgorithm;
    private final Instant notAfter;
    private final Instant notBefore;
    private final LoadBalancerTlsCertificateRenewalSummary renewalSummary;
    private final String revocationReason;
    private final Instant revokedAt;
    private final String serial;
    private final String signatureAlgorithm;
    private final String subject;
    private final List<String> subjectAlternativeNames;

    private LoadBalancerTlsCertificate(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.supportCode = builder.supportCode;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.tags = builder.tags;
        this.loadBalancerName = builder.loadBalancerName;
        this.isAttached = builder.isAttached;
        this.status = builder.status;
        this.domainName = builder.domainName;
        this.domainValidationRecords = builder.domainValidationRecords;
        this.failureReason = builder.failureReason;
        this.issuedAt = builder.issuedAt;
        this.issuer = builder.issuer;
        this.keyAlgorithm = builder.keyAlgorithm;
        this.notAfter = builder.notAfter;
        this.notBefore = builder.notBefore;
        this.renewalSummary = builder.renewalSummary;
        this.revocationReason = builder.revocationReason;
        this.revokedAt = builder.revokedAt;
        this.serial = builder.serial;
        this.signatureAlgorithm = builder.signatureAlgorithm;
        this.subject = builder.subject;
        this.subjectAlternativeNames = builder.subjectAlternativeNames;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String supportCode() {
        return this.supportCode;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final Boolean isAttached() {
        return this.isAttached;
    }

    public final LoadBalancerTlsCertificateStatus status() {
        return LoadBalancerTlsCertificateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasDomainValidationRecords() {
        return this.domainValidationRecords != null && !(this.domainValidationRecords instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords() {
        return this.domainValidationRecords;
    }

    public final LoadBalancerTlsCertificateFailureReason failureReason() {
        return LoadBalancerTlsCertificateFailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public final Instant issuedAt() {
        return this.issuedAt;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final String keyAlgorithm() {
        return this.keyAlgorithm;
    }

    public final Instant notAfter() {
        return this.notAfter;
    }

    public final Instant notBefore() {
        return this.notBefore;
    }

    public final LoadBalancerTlsCertificateRenewalSummary renewalSummary() {
        return this.renewalSummary;
    }

    public final LoadBalancerTlsCertificateRevocationReason revocationReason() {
        return LoadBalancerTlsCertificateRevocationReason.fromValue(this.revocationReason);
    }

    public final String revocationReasonAsString() {
        return this.revocationReason;
    }

    public final Instant revokedAt() {
        return this.revokedAt;
    }

    public final String serial() {
        return this.serial;
    }

    public final String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final String subject() {
        return this.subject;
    }

    public final boolean hasSubjectAlternativeNames() {
        return this.subjectAlternativeNames != null && !(this.subjectAlternativeNames instanceof SdkAutoConstructList);
    }

    public final List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isAttached());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainValidationRecords() ? this.domainValidationRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.notAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.renewalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.revokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.serial());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificate)) {
            return false;
        }
        LoadBalancerTlsCertificate other = (LoadBalancerTlsCertificate)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.supportCode(), other.supportCode()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.isAttached(), other.isAttached()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.domainName(), other.domainName()) && this.hasDomainValidationRecords() == other.hasDomainValidationRecords() && Objects.equals(this.domainValidationRecords(), other.domainValidationRecords()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString()) && Objects.equals(this.issuedAt(), other.issuedAt()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.keyAlgorithm(), other.keyAlgorithm()) && Objects.equals(this.notAfter(), other.notAfter()) && Objects.equals(this.notBefore(), other.notBefore()) && Objects.equals(this.renewalSummary(), other.renewalSummary()) && Objects.equals(this.revocationReasonAsString(), other.revocationReasonAsString()) && Objects.equals(this.revokedAt(), other.revokedAt()) && Objects.equals(this.serial(), other.serial()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm()) && Objects.equals(this.subject(), other.subject()) && this.hasSubjectAlternativeNames() == other.hasSubjectAlternativeNames() && Objects.equals(this.subjectAlternativeNames(), other.subjectAlternativeNames());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancerTlsCertificate").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("SupportCode", (Object)this.supportCode()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("LoadBalancerName", (Object)this.loadBalancerName()).add("IsAttached", (Object)this.isAttached()).add("Status", (Object)this.statusAsString()).add("DomainName", (Object)this.domainName()).add("DomainValidationRecords", this.hasDomainValidationRecords() ? this.domainValidationRecords() : null).add("FailureReason", (Object)this.failureReasonAsString()).add("IssuedAt", (Object)this.issuedAt()).add("Issuer", (Object)this.issuer()).add("KeyAlgorithm", (Object)this.keyAlgorithm()).add("NotAfter", (Object)this.notAfter()).add("NotBefore", (Object)this.notBefore()).add("RenewalSummary", (Object)this.renewalSummary()).add("RevocationReason", (Object)this.revocationReasonAsString()).add("RevokedAt", (Object)this.revokedAt()).add("Serial", (Object)this.serial()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).add("Subject", (Object)this.subject()).add("SubjectAlternativeNames", this.hasSubjectAlternativeNames() ? this.subjectAlternativeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "supportCode": {
                return Optional.ofNullable(clazz.cast(this.supportCode()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "loadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "isAttached": {
                return Optional.ofNullable(clazz.cast(this.isAttached()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "domainValidationRecords": {
                return Optional.ofNullable(clazz.cast(this.domainValidationRecords()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
            case "issuedAt": {
                return Optional.ofNullable(clazz.cast(this.issuedAt()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "keyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyAlgorithm()));
            }
            case "notAfter": {
                return Optional.ofNullable(clazz.cast(this.notAfter()));
            }
            case "notBefore": {
                return Optional.ofNullable(clazz.cast(this.notBefore()));
            }
            case "renewalSummary": {
                return Optional.ofNullable(clazz.cast(this.renewalSummary()));
            }
            case "revocationReason": {
                return Optional.ofNullable(clazz.cast(this.revocationReasonAsString()));
            }
            case "revokedAt": {
                return Optional.ofNullable(clazz.cast(this.revokedAt()));
            }
            case "serial": {
                return Optional.ofNullable(clazz.cast(this.serial()));
            }
            case "signatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signatureAlgorithm()));
            }
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "subjectAlternativeNames": {
                return Optional.ofNullable(clazz.cast(this.subjectAlternativeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificate, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String supportCode;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String loadBalancerName;
        private Boolean isAttached;
        private String status;
        private String domainName;
        private List<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords = DefaultSdkAutoConstructList.getInstance();
        private String failureReason;
        private Instant issuedAt;
        private String issuer;
        private String keyAlgorithm;
        private Instant notAfter;
        private Instant notBefore;
        private LoadBalancerTlsCertificateRenewalSummary renewalSummary;
        private String revocationReason;
        private Instant revokedAt;
        private String serial;
        private String signatureAlgorithm;
        private String subject;
        private List<String> subjectAlternativeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificate model) {
            this.name(model.name);
            this.arn(model.arn);
            this.supportCode(model.supportCode);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.tags(model.tags);
            this.loadBalancerName(model.loadBalancerName);
            this.isAttached(model.isAttached);
            this.status(model.status);
            this.domainName(model.domainName);
            this.domainValidationRecords(model.domainValidationRecords);
            this.failureReason(model.failureReason);
            this.issuedAt(model.issuedAt);
            this.issuer(model.issuer);
            this.keyAlgorithm(model.keyAlgorithm);
            this.notAfter(model.notAfter);
            this.notBefore(model.notBefore);
            this.renewalSummary(model.renewalSummary);
            this.revocationReason(model.revocationReason);
            this.revokedAt(model.revokedAt);
            this.serial(model.serial);
            this.signatureAlgorithm(model.signatureAlgorithm);
            this.subject(model.subject);
            this.subjectAlternativeNames(model.subjectAlternativeNames);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSupportCode() {
            return this.supportCode;
        }

        @Override
        public final Builder supportCode(String supportCode) {
            this.supportCode = supportCode;
            return this;
        }

        public final void setSupportCode(String supportCode) {
            this.supportCode = supportCode;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        public final Boolean getIsAttached() {
            return this.isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LoadBalancerTlsCertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final List<LoadBalancerTlsCertificateDomainValidationRecord.Builder> getDomainValidationRecords() {
            List<LoadBalancerTlsCertificateDomainValidationRecord.Builder> result = LoadBalancerTlsCertificateDomainValidationRecordListCopier.copyToBuilder(this.domainValidationRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder domainValidationRecords(Collection<LoadBalancerTlsCertificateDomainValidationRecord> domainValidationRecords) {
            this.domainValidationRecords = LoadBalancerTlsCertificateDomainValidationRecordListCopier.copy(domainValidationRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(LoadBalancerTlsCertificateDomainValidationRecord ... domainValidationRecords) {
            this.domainValidationRecords(Arrays.asList(domainValidationRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainValidationRecords(Consumer<LoadBalancerTlsCertificateDomainValidationRecord.Builder> ... domainValidationRecords) {
            this.domainValidationRecords(Stream.of(domainValidationRecords).map(c -> (LoadBalancerTlsCertificateDomainValidationRecord)((LoadBalancerTlsCertificateDomainValidationRecord.Builder)LoadBalancerTlsCertificateDomainValidationRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainValidationRecords(Collection<LoadBalancerTlsCertificateDomainValidationRecord.BuilderImpl> domainValidationRecords) {
            this.domainValidationRecords = LoadBalancerTlsCertificateDomainValidationRecordListCopier.copyFromBuilder(domainValidationRecords);
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(LoadBalancerTlsCertificateFailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getIssuedAt() {
            return this.issuedAt;
        }

        @Override
        public final Builder issuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
            return this;
        }

        public final void setIssuedAt(Instant issuedAt) {
            this.issuedAt = issuedAt;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public final String getKeyAlgorithm() {
            return this.keyAlgorithm;
        }

        @Override
        public final Builder keyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            return this;
        }

        public final void setKeyAlgorithm(String keyAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
        }

        public final Instant getNotAfter() {
            return this.notAfter;
        }

        @Override
        public final Builder notAfter(Instant notAfter) {
            this.notAfter = notAfter;
            return this;
        }

        public final void setNotAfter(Instant notAfter) {
            this.notAfter = notAfter;
        }

        public final Instant getNotBefore() {
            return this.notBefore;
        }

        @Override
        public final Builder notBefore(Instant notBefore) {
            this.notBefore = notBefore;
            return this;
        }

        public final void setNotBefore(Instant notBefore) {
            this.notBefore = notBefore;
        }

        public final LoadBalancerTlsCertificateRenewalSummary.Builder getRenewalSummary() {
            return this.renewalSummary != null ? this.renewalSummary.toBuilder() : null;
        }

        @Override
        public final Builder renewalSummary(LoadBalancerTlsCertificateRenewalSummary renewalSummary) {
            this.renewalSummary = renewalSummary;
            return this;
        }

        public final void setRenewalSummary(LoadBalancerTlsCertificateRenewalSummary.BuilderImpl renewalSummary) {
            this.renewalSummary = renewalSummary != null ? renewalSummary.build() : null;
        }

        public final String getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public final Builder revocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
            return this;
        }

        @Override
        public final Builder revocationReason(LoadBalancerTlsCertificateRevocationReason revocationReason) {
            this.revocationReason(revocationReason == null ? null : revocationReason.toString());
            return this;
        }

        public final void setRevocationReason(String revocationReason) {
            this.revocationReason = revocationReason;
        }

        public final Instant getRevokedAt() {
            return this.revokedAt;
        }

        @Override
        public final Builder revokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        public final void setRevokedAt(Instant revokedAt) {
            this.revokedAt = revokedAt;
        }

        public final String getSerial() {
            return this.serial;
        }

        @Override
        public final Builder serial(String serial) {
            this.serial = serial;
            return this;
        }

        public final void setSerial(String serial) {
            this.serial = serial;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        public final String getSubject() {
            return this.subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final Collection<String> getSubjectAlternativeNames() {
            if (this.subjectAlternativeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subjectAlternativeNames;
        }

        @Override
        public final Builder subjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectAlternativeNames(String ... subjectAlternativeNames) {
            this.subjectAlternativeNames(Arrays.asList(subjectAlternativeNames));
            return this;
        }

        public final void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
            this.subjectAlternativeNames = StringListCopier.copy(subjectAlternativeNames);
        }

        public LoadBalancerTlsCertificate build() {
            return new LoadBalancerTlsCertificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerTlsCertificate> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder supportCode(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder loadBalancerName(String var1);

        public Builder isAttached(Boolean var1);

        public Builder status(String var1);

        public Builder status(LoadBalancerTlsCertificateStatus var1);

        public Builder domainName(String var1);

        public Builder domainValidationRecords(Collection<LoadBalancerTlsCertificateDomainValidationRecord> var1);

        public Builder domainValidationRecords(LoadBalancerTlsCertificateDomainValidationRecord ... var1);

        public Builder domainValidationRecords(Consumer<LoadBalancerTlsCertificateDomainValidationRecord.Builder> ... var1);

        public Builder failureReason(String var1);

        public Builder failureReason(LoadBalancerTlsCertificateFailureReason var1);

        public Builder issuedAt(Instant var1);

        public Builder issuer(String var1);

        public Builder keyAlgorithm(String var1);

        public Builder notAfter(Instant var1);

        public Builder notBefore(Instant var1);

        public Builder renewalSummary(LoadBalancerTlsCertificateRenewalSummary var1);

        default public Builder renewalSummary(Consumer<LoadBalancerTlsCertificateRenewalSummary.Builder> renewalSummary) {
            return this.renewalSummary((LoadBalancerTlsCertificateRenewalSummary)((LoadBalancerTlsCertificateRenewalSummary.Builder)LoadBalancerTlsCertificateRenewalSummary.builder().applyMutation(renewalSummary)).build());
        }

        public Builder revocationReason(String var1);

        public Builder revocationReason(LoadBalancerTlsCertificateRevocationReason var1);

        public Builder revokedAt(Instant var1);

        public Builder serial(String var1);

        public Builder signatureAlgorithm(String var1);

        public Builder subject(String var1);

        public Builder subjectAlternativeNames(Collection<String> var1);

        public Builder subjectAlternativeNames(String ... var1);
    }
}

