/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ContainerServiceState {
    PENDING("PENDING"),
    READY("READY"),
    RUNNING("RUNNING"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DISABLED("DISABLED"),
    DEPLOYING("DEPLOYING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ContainerServiceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerServiceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ContainerServiceState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerServiceState> knownValues() {
        return Stream.of(ContainerServiceState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

