/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfo;
import software.amazon.awssdk.services.lightsail.model.CloudFormationStackRecordSourceInfoListCopier;
import software.amazon.awssdk.services.lightsail.model.DestinationInfo;
import software.amazon.awssdk.services.lightsail.model.RecordState;
import software.amazon.awssdk.services.lightsail.model.ResourceLocation;
import software.amazon.awssdk.services.lightsail.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFormationStackRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFormationStackRecord> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::name)).setter(CloudFormationStackRecord.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::arn)).setter(CloudFormationStackRecord.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::createdAt)).setter(CloudFormationStackRecord.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<ResourceLocation> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::location)).setter(CloudFormationStackRecord.setter(Builder::location)).constructor(ResourceLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::resourceTypeAsString)).setter(CloudFormationStackRecord.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::stateAsString)).setter(CloudFormationStackRecord.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<List<CloudFormationStackRecordSourceInfo>> SOURCE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceInfo").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::sourceInfo)).setter(CloudFormationStackRecord.setter(Builder::sourceInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudFormationStackRecordSourceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DestinationInfo> DESTINATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationInfo").getter(CloudFormationStackRecord.getter(CloudFormationStackRecord::destinationInfo)).setter(CloudFormationStackRecord.setter(Builder::destinationInfo)).constructor(DestinationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, CREATED_AT_FIELD, LOCATION_FIELD, RESOURCE_TYPE_FIELD, STATE_FIELD, SOURCE_INFO_FIELD, DESTINATION_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Instant createdAt;
    private final ResourceLocation location;
    private final String resourceType;
    private final String state;
    private final List<CloudFormationStackRecordSourceInfo> sourceInfo;
    private final DestinationInfo destinationInfo;

    private CloudFormationStackRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.location = builder.location;
        this.resourceType = builder.resourceType;
        this.state = builder.state;
        this.sourceInfo = builder.sourceInfo;
        this.destinationInfo = builder.destinationInfo;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ResourceLocation location() {
        return this.location;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final RecordState state() {
        return RecordState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasSourceInfo() {
        return this.sourceInfo != null && !(this.sourceInfo instanceof SdkAutoConstructList);
    }

    public final List<CloudFormationStackRecordSourceInfo> sourceInfo() {
        return this.sourceInfo;
    }

    public final DestinationInfo destinationInfo() {
        return this.destinationInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceInfo() ? this.sourceInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationStackRecord)) {
            return false;
        }
        CloudFormationStackRecord other = (CloudFormationStackRecord)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasSourceInfo() == other.hasSourceInfo() && Objects.equals(this.sourceInfo(), other.sourceInfo()) && Objects.equals(this.destinationInfo(), other.destinationInfo());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFormationStackRecord").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Location", (Object)this.location()).add("ResourceType", (Object)this.resourceTypeAsString()).add("State", (Object)this.stateAsString()).add("SourceInfo", this.hasSourceInfo() ? this.sourceInfo() : null).add("DestinationInfo", (Object)this.destinationInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "sourceInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceInfo()));
            }
            case "destinationInfo": {
                return Optional.ofNullable(clazz.cast(this.destinationInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationStackRecord, T> g) {
        return obj -> g.apply((CloudFormationStackRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Instant createdAt;
        private ResourceLocation location;
        private String resourceType;
        private String state;
        private List<CloudFormationStackRecordSourceInfo> sourceInfo = DefaultSdkAutoConstructList.getInstance();
        private DestinationInfo destinationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationStackRecord model) {
            this.name(model.name);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.location(model.location);
            this.resourceType(model.resourceType);
            this.state(model.state);
            this.sourceInfo(model.sourceInfo);
            this.destinationInfo(model.destinationInfo);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final ResourceLocation.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        @Override
        public final Builder location(ResourceLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(ResourceLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RecordState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final List<CloudFormationStackRecordSourceInfo.Builder> getSourceInfo() {
            List<CloudFormationStackRecordSourceInfo.Builder> result = CloudFormationStackRecordSourceInfoListCopier.copyToBuilder(this.sourceInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sourceInfo(Collection<CloudFormationStackRecordSourceInfo> sourceInfo) {
            this.sourceInfo = CloudFormationStackRecordSourceInfoListCopier.copy(sourceInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceInfo(CloudFormationStackRecordSourceInfo ... sourceInfo) {
            this.sourceInfo(Arrays.asList(sourceInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceInfo(Consumer<CloudFormationStackRecordSourceInfo.Builder> ... sourceInfo) {
            this.sourceInfo(Stream.of(sourceInfo).map(c -> (CloudFormationStackRecordSourceInfo)((CloudFormationStackRecordSourceInfo.Builder)CloudFormationStackRecordSourceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceInfo(Collection<CloudFormationStackRecordSourceInfo.BuilderImpl> sourceInfo) {
            this.sourceInfo = CloudFormationStackRecordSourceInfoListCopier.copyFromBuilder(sourceInfo);
        }

        public final DestinationInfo.Builder getDestinationInfo() {
            return this.destinationInfo != null ? this.destinationInfo.toBuilder() : null;
        }

        @Override
        public final Builder destinationInfo(DestinationInfo destinationInfo) {
            this.destinationInfo = destinationInfo;
            return this;
        }

        public final void setDestinationInfo(DestinationInfo.BuilderImpl destinationInfo) {
            this.destinationInfo = destinationInfo != null ? destinationInfo.build() : null;
        }

        public CloudFormationStackRecord build() {
            return new CloudFormationStackRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFormationStackRecord> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder location(ResourceLocation var1);

        default public Builder location(Consumer<ResourceLocation.Builder> location) {
            return this.location((ResourceLocation)((ResourceLocation.Builder)ResourceLocation.builder().applyMutation(location)).build());
        }

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder state(String var1);

        public Builder state(RecordState var1);

        public Builder sourceInfo(Collection<CloudFormationStackRecordSourceInfo> var1);

        public Builder sourceInfo(CloudFormationStackRecordSourceInfo ... var1);

        public Builder sourceInfo(Consumer<CloudFormationStackRecordSourceInfo.Builder> ... var1);

        public Builder destinationInfo(DestinationInfo var1);

        default public Builder destinationInfo(Consumer<DestinationInfo.Builder> destinationInfo) {
            return this.destinationInfo((DestinationInfo)((DestinationInfo.Builder)DestinationInfo.builder().applyMutation(destinationInfo)).build());
        }
    }
}

