/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DigitalSignatureMethod {
    JWT_PS384("JWT_PS384"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DigitalSignatureMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DigitalSignatureMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DigitalSignatureMethod.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DigitalSignatureMethod> knownValues() {
        return Stream.of(DigitalSignatureMethod.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

