/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BorrowConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BorrowConfiguration> {
    private static final SdkField<Boolean> ALLOW_EARLY_CHECK_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowEarlyCheckIn").getter(BorrowConfiguration.getter(BorrowConfiguration::allowEarlyCheckIn)).setter(BorrowConfiguration.setter(Builder::allowEarlyCheckIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowEarlyCheckIn").build()}).build();
    private static final SdkField<Integer> MAX_TIME_TO_LIVE_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxTimeToLiveInMinutes").getter(BorrowConfiguration.getter(BorrowConfiguration::maxTimeToLiveInMinutes)).setter(BorrowConfiguration.setter(Builder::maxTimeToLiveInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTimeToLiveInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_EARLY_CHECK_IN_FIELD, MAX_TIME_TO_LIVE_IN_MINUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean allowEarlyCheckIn;
    private final Integer maxTimeToLiveInMinutes;

    private BorrowConfiguration(BuilderImpl builder) {
        this.allowEarlyCheckIn = builder.allowEarlyCheckIn;
        this.maxTimeToLiveInMinutes = builder.maxTimeToLiveInMinutes;
    }

    public final Boolean allowEarlyCheckIn() {
        return this.allowEarlyCheckIn;
    }

    public final Integer maxTimeToLiveInMinutes() {
        return this.maxTimeToLiveInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowEarlyCheckIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxTimeToLiveInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BorrowConfiguration)) {
            return false;
        }
        BorrowConfiguration other = (BorrowConfiguration)obj;
        return Objects.equals(this.allowEarlyCheckIn(), other.allowEarlyCheckIn()) && Objects.equals(this.maxTimeToLiveInMinutes(), other.maxTimeToLiveInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"BorrowConfiguration").add("AllowEarlyCheckIn", (Object)this.allowEarlyCheckIn()).add("MaxTimeToLiveInMinutes", (Object)this.maxTimeToLiveInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowEarlyCheckIn": {
                return Optional.ofNullable(clazz.cast(this.allowEarlyCheckIn()));
            }
            case "MaxTimeToLiveInMinutes": {
                return Optional.ofNullable(clazz.cast(this.maxTimeToLiveInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BorrowConfiguration, T> g) {
        return obj -> g.apply((BorrowConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allowEarlyCheckIn;
        private Integer maxTimeToLiveInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BorrowConfiguration model) {
            this.allowEarlyCheckIn(model.allowEarlyCheckIn);
            this.maxTimeToLiveInMinutes(model.maxTimeToLiveInMinutes);
        }

        public final Boolean getAllowEarlyCheckIn() {
            return this.allowEarlyCheckIn;
        }

        @Override
        public final Builder allowEarlyCheckIn(Boolean allowEarlyCheckIn) {
            this.allowEarlyCheckIn = allowEarlyCheckIn;
            return this;
        }

        public final void setAllowEarlyCheckIn(Boolean allowEarlyCheckIn) {
            this.allowEarlyCheckIn = allowEarlyCheckIn;
        }

        public final Integer getMaxTimeToLiveInMinutes() {
            return this.maxTimeToLiveInMinutes;
        }

        @Override
        public final Builder maxTimeToLiveInMinutes(Integer maxTimeToLiveInMinutes) {
            this.maxTimeToLiveInMinutes = maxTimeToLiveInMinutes;
            return this;
        }

        public final void setMaxTimeToLiveInMinutes(Integer maxTimeToLiveInMinutes) {
            this.maxTimeToLiveInMinutes = maxTimeToLiveInMinutes;
        }

        public BorrowConfiguration build() {
            return new BorrowConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BorrowConfiguration> {
        public Builder allowEarlyCheckIn(Boolean var1);

        public Builder maxTimeToLiveInMinutes(Integer var1);
    }
}

