/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketLogDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketLogDestination> {
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(S3BucketLogDestination.getter(S3BucketLogDestination::kmsKeyArn)).setter(S3BucketLogDestination.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<String> S3_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketArn").getter(S3BucketLogDestination.getter(S3BucketLogDestination::s3BucketArn)).setter(S3BucketLogDestination.setter(Builder::s3BucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketArn").build()}).build();
    private static final SdkField<String> LOG_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logPrefix").getter(S3BucketLogDestination.getter(S3BucketLogDestination::logPrefix)).setter(S3BucketLogDestination.setter(Builder::logPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ARN_FIELD, S3_BUCKET_ARN_FIELD, LOG_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kmsKeyArn;
    private final String s3BucketArn;
    private final String logPrefix;

    private S3BucketLogDestination(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn;
        this.s3BucketArn = builder.s3BucketArn;
        this.logPrefix = builder.logPrefix;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final String s3BucketArn() {
        return this.s3BucketArn;
    }

    public final String logPrefix() {
        return this.logPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketLogDestination)) {
            return false;
        }
        S3BucketLogDestination other = (S3BucketLogDestination)obj;
        return Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.s3BucketArn(), other.s3BucketArn()) && Objects.equals(this.logPrefix(), other.logPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketLogDestination").add("KmsKeyArn", (Object)this.kmsKeyArn()).add("S3BucketArn", (Object)this.s3BucketArn()).add("LogPrefix", (Object)this.logPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "s3BucketArn": {
                return Optional.ofNullable(clazz.cast(this.s3BucketArn()));
            }
            case "logPrefix": {
                return Optional.ofNullable(clazz.cast(this.logPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketLogDestination, T> g) {
        return obj -> g.apply((S3BucketLogDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyArn;
        private String s3BucketArn;
        private String logPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketLogDestination model) {
            this.kmsKeyArn(model.kmsKeyArn);
            this.s3BucketArn(model.s3BucketArn);
            this.logPrefix(model.logPrefix);
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getS3BucketArn() {
            return this.s3BucketArn;
        }

        @Override
        public final Builder s3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
            return this;
        }

        public final void setS3BucketArn(String s3BucketArn) {
            this.s3BucketArn = s3BucketArn;
        }

        public final String getLogPrefix() {
            return this.logPrefix;
        }

        @Override
        public final Builder logPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
            return this;
        }

        public final void setLogPrefix(String logPrefix) {
            this.logPrefix = logPrefix;
        }

        public S3BucketLogDestination build() {
            return new S3BucketLogDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketLogDestination> {
        public Builder kmsKeyArn(String var1);

        public Builder s3BucketArn(String var1);

        public Builder logPrefix(String var1);
    }
}

