/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BuiltInIntentSortBy;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBuiltInIntentsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListBuiltInIntentsRequest> {
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(ListBuiltInIntentsRequest.getter(ListBuiltInIntentsRequest::localeId)).setter(ListBuiltInIntentsRequest.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()}).build();
    private static final SdkField<BuiltInIntentSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(ListBuiltInIntentsRequest.getter(ListBuiltInIntentsRequest::sortBy)).setter(ListBuiltInIntentsRequest.setter(Builder::sortBy)).constructor(BuiltInIntentSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListBuiltInIntentsRequest.getter(ListBuiltInIntentsRequest::maxResults)).setter(ListBuiltInIntentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBuiltInIntentsRequest.getter(ListBuiltInIntentsRequest::nextToken)).setter(ListBuiltInIntentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_ID_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String localeId;
    private final BuiltInIntentSortBy sortBy;
    private final Integer maxResults;
    private final String nextToken;

    private ListBuiltInIntentsRequest(BuilderImpl builder) {
        super(builder);
        this.localeId = builder.localeId;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final BuiltInIntentSortBy sortBy() {
        return this.sortBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBuiltInIntentsRequest)) {
            return false;
        }
        ListBuiltInIntentsRequest other = (ListBuiltInIntentsRequest)((Object)obj);
        return Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBuiltInIntentsRequest").add("LocaleId", (Object)this.localeId()).add("SortBy", (Object)this.sortBy()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBuiltInIntentsRequest, T> g) {
        return obj -> g.apply((ListBuiltInIntentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String localeId;
        private BuiltInIntentSortBy sortBy;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBuiltInIntentsRequest model) {
            super(model);
            this.localeId(model.localeId);
            this.sortBy(model.sortBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        public final BuiltInIntentSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        @Override
        public final Builder sortBy(BuiltInIntentSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final void setSortBy(BuiltInIntentSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBuiltInIntentsRequest build() {
            return new ListBuiltInIntentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBuiltInIntentsRequest> {
        public Builder localeId(String var1);

        public Builder sortBy(BuiltInIntentSortBy var1);

        default public Builder sortBy(Consumer<BuiltInIntentSortBy.Builder> sortBy) {
            return this.sortBy((BuiltInIntentSortBy)((BuiltInIntentSortBy.Builder)BuiltInIntentSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

