/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SlotValueSelectionStrategy {
    ORIGINAL_VALUE("ORIGINAL_VALUE"),
    TOP_RESOLUTION("TOP_RESOLUTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SlotValueSelectionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SlotValueSelectionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SlotValueSelectionStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SlotValueSelectionStrategy> knownValues() {
        return Stream.of(SlotValueSelectionStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

