/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EndPointType {
    KAFKA_BOOTSTRAP_SERVERS("KAFKA_BOOTSTRAP_SERVERS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EndPointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndPointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EndPointType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndPointType> knownValues() {
        return Stream.of(EndPointType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

