/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGrantResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, CreateGrantResponse> {
    private static final SdkField<String> GRANT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantToken").getter(CreateGrantResponse.getter(CreateGrantResponse::grantToken)).setter(CreateGrantResponse.setter(Builder::grantToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantToken").build()}).build();
    private static final SdkField<String> GRANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrantId").getter(CreateGrantResponse.getter(CreateGrantResponse::grantId)).setter(CreateGrantResponse.setter(Builder::grantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANT_TOKEN_FIELD, GRANT_ID_FIELD));
    private final String grantToken;
    private final String grantId;

    private CreateGrantResponse(BuilderImpl builder) {
        super(builder);
        this.grantToken = builder.grantToken;
        this.grantId = builder.grantId;
    }

    public final String grantToken() {
        return this.grantToken;
    }

    public final String grantId() {
        return this.grantId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.grantToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantResponse)) {
            return false;
        }
        CreateGrantResponse other = (CreateGrantResponse)((Object)obj);
        return Objects.equals(this.grantToken(), other.grantToken()) && Objects.equals(this.grantId(), other.grantId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGrantResponse").add("GrantToken", (Object)this.grantToken()).add("GrantId", (Object)this.grantId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GrantToken": {
                return Optional.ofNullable(clazz.cast(this.grantToken()));
            }
            case "GrantId": {
                return Optional.ofNullable(clazz.cast(this.grantId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGrantResponse, T> g) {
        return obj -> g.apply((CreateGrantResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private String grantToken;
        private String grantId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGrantResponse model) {
            super(model);
            this.grantToken(model.grantToken);
            this.grantId(model.grantId);
        }

        public final String getGrantToken() {
            return this.grantToken;
        }

        @Override
        public final Builder grantToken(String grantToken) {
            this.grantToken = grantToken;
            return this;
        }

        public final void setGrantToken(String grantToken) {
            this.grantToken = grantToken;
        }

        public final String getGrantId() {
            return this.grantId;
        }

        @Override
        public final Builder grantId(String grantId) {
            this.grantId = grantId;
            return this;
        }

        public final void setGrantId(String grantId) {
            this.grantId = grantId;
        }

        @Override
        public CreateGrantResponse build() {
            return new CreateGrantResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGrantResponse> {
        public Builder grantToken(String var1);

        public Builder grantId(String var1);
    }
}

