/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DataKeyPairSpec {
    RSA_2048("RSA_2048"),
    RSA_3072("RSA_3072"),
    RSA_4096("RSA_4096"),
    ECC_NIST_P256("ECC_NIST_P256"),
    ECC_NIST_P384("ECC_NIST_P384"),
    ECC_NIST_P521("ECC_NIST_P521"),
    ECC_SECG_P256_K1("ECC_SECG_P256K1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DataKeyPairSpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataKeyPairSpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DataKeyPairSpec.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataKeyPairSpec> knownValues() {
        return Stream.of(DataKeyPairSpec.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

