/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ConfigurationType;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.LogLevel;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringConfigurationDescription> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationType").getter(MonitoringConfigurationDescription.getter(MonitoringConfigurationDescription::configurationTypeAsString)).setter(MonitoringConfigurationDescription.setter(Builder::configurationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationType").build()}).build();
    private static final SdkField<String> METRICS_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricsLevel").getter(MonitoringConfigurationDescription.getter(MonitoringConfigurationDescription::metricsLevelAsString)).setter(MonitoringConfigurationDescription.setter(Builder::metricsLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsLevel").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(MonitoringConfigurationDescription.getter(MonitoringConfigurationDescription::logLevelAsString)).setter(MonitoringConfigurationDescription.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD, METRICS_LEVEL_FIELD, LOG_LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String configurationType;
    private final String metricsLevel;
    private final String logLevel;

    private MonitoringConfigurationDescription(BuilderImpl builder) {
        this.configurationType = builder.configurationType;
        this.metricsLevel = builder.metricsLevel;
        this.logLevel = builder.logLevel;
    }

    public final ConfigurationType configurationType() {
        return ConfigurationType.fromValue(this.configurationType);
    }

    public final String configurationTypeAsString() {
        return this.configurationType;
    }

    public final MetricsLevel metricsLevel() {
        return MetricsLevel.fromValue(this.metricsLevel);
    }

    public final String metricsLevelAsString() {
        return this.metricsLevel;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricsLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringConfigurationDescription)) {
            return false;
        }
        MonitoringConfigurationDescription other = (MonitoringConfigurationDescription)obj;
        return Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && Objects.equals(this.metricsLevelAsString(), other.metricsLevelAsString()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MonitoringConfigurationDescription").add("ConfigurationType", (Object)this.configurationTypeAsString()).add("MetricsLevel", (Object)this.metricsLevelAsString()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "MetricsLevel": {
                return Optional.ofNullable(clazz.cast(this.metricsLevelAsString()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringConfigurationDescription, T> g) {
        return obj -> g.apply((MonitoringConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configurationType;
        private String metricsLevel;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringConfigurationDescription model) {
            this.configurationType(model.configurationType);
            this.metricsLevel(model.metricsLevel);
            this.logLevel(model.logLevel);
        }

        public final String getConfigurationType() {
            return this.configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(ConfigurationType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        public final String getMetricsLevel() {
            return this.metricsLevel;
        }

        @Override
        public final Builder metricsLevel(String metricsLevel) {
            this.metricsLevel = metricsLevel;
            return this;
        }

        @Override
        public final Builder metricsLevel(MetricsLevel metricsLevel) {
            this.metricsLevel(metricsLevel == null ? null : metricsLevel.toString());
            return this;
        }

        public final void setMetricsLevel(String metricsLevel) {
            this.metricsLevel = metricsLevel;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        public MonitoringConfigurationDescription build() {
            return new MonitoringConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringConfigurationDescription> {
        public Builder configurationType(String var1);

        public Builder configurationType(ConfigurationType var1);

        public Builder metricsLevel(String var1);

        public Builder metricsLevel(MetricsLevel var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);
    }
}

