/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContent;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationCodeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationCodeConfiguration> {
    private static final SdkField<CodeContent> CODE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeContent").getter(ApplicationCodeConfiguration.getter(ApplicationCodeConfiguration::codeContent)).setter(ApplicationCodeConfiguration.setter(Builder::codeContent)).constructor(CodeContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContent").build()}).build();
    private static final SdkField<String> CODE_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeContentType").getter(ApplicationCodeConfiguration.getter(ApplicationCodeConfiguration::codeContentTypeAsString)).setter(ApplicationCodeConfiguration.setter(Builder::codeContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_CONTENT_FIELD, CODE_CONTENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CodeContent codeContent;
    private final String codeContentType;

    private ApplicationCodeConfiguration(BuilderImpl builder) {
        this.codeContent = builder.codeContent;
        this.codeContentType = builder.codeContentType;
    }

    public final CodeContent codeContent() {
        return this.codeContent;
    }

    public final CodeContentType codeContentType() {
        return CodeContentType.fromValue(this.codeContentType);
    }

    public final String codeContentTypeAsString() {
        return this.codeContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeContentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationCodeConfiguration)) {
            return false;
        }
        ApplicationCodeConfiguration other = (ApplicationCodeConfiguration)obj;
        return Objects.equals(this.codeContent(), other.codeContent()) && Objects.equals(this.codeContentTypeAsString(), other.codeContentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationCodeConfiguration").add("CodeContent", (Object)this.codeContent()).add("CodeContentType", (Object)this.codeContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeContent": {
                return Optional.ofNullable(clazz.cast(this.codeContent()));
            }
            case "CodeContentType": {
                return Optional.ofNullable(clazz.cast(this.codeContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationCodeConfiguration, T> g) {
        return obj -> g.apply((ApplicationCodeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeContent codeContent;
        private String codeContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationCodeConfiguration model) {
            this.codeContent(model.codeContent);
            this.codeContentType(model.codeContentType);
        }

        public final CodeContent.Builder getCodeContent() {
            return this.codeContent != null ? this.codeContent.toBuilder() : null;
        }

        @Override
        public final Builder codeContent(CodeContent codeContent) {
            this.codeContent = codeContent;
            return this;
        }

        public final void setCodeContent(CodeContent.BuilderImpl codeContent) {
            this.codeContent = codeContent != null ? codeContent.build() : null;
        }

        public final String getCodeContentType() {
            return this.codeContentType;
        }

        @Override
        public final Builder codeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
            return this;
        }

        @Override
        public final Builder codeContentType(CodeContentType codeContentType) {
            this.codeContentType(codeContentType == null ? null : codeContentType.toString());
            return this;
        }

        public final void setCodeContentType(String codeContentType) {
            this.codeContentType = codeContentType;
        }

        public ApplicationCodeConfiguration build() {
            return new ApplicationCodeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationCodeConfiguration> {
        public Builder codeContent(CodeContent var1);

        default public Builder codeContent(Consumer<CodeContent.Builder> codeContent) {
            return this.codeContent((CodeContent)((CodeContent.Builder)CodeContent.builder().applyMutation(codeContent)).build());
        }

        public Builder codeContentType(String var1);

        public Builder codeContentType(CodeContentType var1);
    }
}

