/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecreaseStreamRetentionPeriodRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DecreaseStreamRetentionPeriodRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DecreaseStreamRetentionPeriodRequest.getter(DecreaseStreamRetentionPeriodRequest::streamName)).setter(DecreaseStreamRetentionPeriodRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DecreaseStreamRetentionPeriodRequest.getter(DecreaseStreamRetentionPeriodRequest::retentionPeriodHours)).setter(DecreaseStreamRetentionPeriodRequest.setter(Builder::retentionPeriodHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, RETENTION_PERIOD_HOURS_FIELD));
    private final String streamName;
    private final Integer retentionPeriodHours;

    private DecreaseStreamRetentionPeriodRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.retentionPeriodHours = builder.retentionPeriodHours;
    }

    public String streamName() {
        return this.streamName;
    }

    public Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseStreamRetentionPeriodRequest)) {
            return false;
        }
        DecreaseStreamRetentionPeriodRequest other = (DecreaseStreamRetentionPeriodRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours());
    }

    public String toString() {
        return ToString.builder((String)"DecreaseStreamRetentionPeriodRequest").add("StreamName", (Object)this.streamName()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "RetentionPeriodHours": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodHours()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DecreaseStreamRetentionPeriodRequest, T> g) {
        return obj -> g.apply((DecreaseStreamRetentionPeriodRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private Integer retentionPeriodHours;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseStreamRetentionPeriodRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.retentionPeriodHours(model.retentionPeriodHours);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseStreamRetentionPeriodRequest build() {
            return new DecreaseStreamRetentionPeriodRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DecreaseStreamRetentionPeriodRequest> {
        public Builder streamName(String var1);

        public Builder retentionPeriodHours(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

