/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceNowServiceCatalogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceNowServiceCatalogConfiguration> {
    private static final SdkField<Boolean> CRAWL_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrawlAttachments").getter(ServiceNowServiceCatalogConfiguration.getter(ServiceNowServiceCatalogConfiguration::crawlAttachments)).setter(ServiceNowServiceCatalogConfiguration.setter(Builder::crawlAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlAttachments").build()}).build();
    private static final SdkField<List<String>> INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludeAttachmentFilePatterns").getter(ServiceNowServiceCatalogConfiguration.getter(ServiceNowServiceCatalogConfiguration::includeAttachmentFilePatterns)).setter(ServiceNowServiceCatalogConfiguration.setter(Builder::includeAttachmentFilePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAttachmentFilePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludeAttachmentFilePatterns").getter(ServiceNowServiceCatalogConfiguration.getter(ServiceNowServiceCatalogConfiguration::excludeAttachmentFilePatterns)).setter(ServiceNowServiceCatalogConfiguration.setter(Builder::excludeAttachmentFilePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeAttachmentFilePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentDataFieldName").getter(ServiceNowServiceCatalogConfiguration.getter(ServiceNowServiceCatalogConfiguration::documentDataFieldName)).setter(ServiceNowServiceCatalogConfiguration.setter(Builder::documentDataFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentTitleFieldName").getter(ServiceNowServiceCatalogConfiguration.getter(ServiceNowServiceCatalogConfiguration::documentTitleFieldName)).setter(ServiceNowServiceCatalogConfiguration.setter(Builder::documentTitleFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(ServiceNowServiceCatalogConfiguration.getter(ServiceNowServiceCatalogConfiguration::fieldMappings)).setter(ServiceNowServiceCatalogConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWL_ATTACHMENTS_FIELD, INCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD, EXCLUDE_ATTACHMENT_FILE_PATTERNS_FIELD, DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean crawlAttachments;
    private final List<String> includeAttachmentFilePatterns;
    private final List<String> excludeAttachmentFilePatterns;
    private final String documentDataFieldName;
    private final String documentTitleFieldName;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private ServiceNowServiceCatalogConfiguration(BuilderImpl builder) {
        this.crawlAttachments = builder.crawlAttachments;
        this.includeAttachmentFilePatterns = builder.includeAttachmentFilePatterns;
        this.excludeAttachmentFilePatterns = builder.excludeAttachmentFilePatterns;
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
    }

    public final Boolean crawlAttachments() {
        return this.crawlAttachments;
    }

    public final boolean hasIncludeAttachmentFilePatterns() {
        return this.includeAttachmentFilePatterns != null && !(this.includeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> includeAttachmentFilePatterns() {
        return this.includeAttachmentFilePatterns;
    }

    public final boolean hasExcludeAttachmentFilePatterns() {
        return this.excludeAttachmentFilePatterns != null && !(this.excludeAttachmentFilePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> excludeAttachmentFilePatterns() {
        return this.excludeAttachmentFilePatterns;
    }

    public final String documentDataFieldName() {
        return this.documentDataFieldName;
    }

    public final String documentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeAttachmentFilePatterns() ? this.includeAttachmentFilePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeAttachmentFilePatterns() ? this.excludeAttachmentFilePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNowServiceCatalogConfiguration)) {
            return false;
        }
        ServiceNowServiceCatalogConfiguration other = (ServiceNowServiceCatalogConfiguration)obj;
        return Objects.equals(this.crawlAttachments(), other.crawlAttachments()) && this.hasIncludeAttachmentFilePatterns() == other.hasIncludeAttachmentFilePatterns() && Objects.equals(this.includeAttachmentFilePatterns(), other.includeAttachmentFilePatterns()) && this.hasExcludeAttachmentFilePatterns() == other.hasExcludeAttachmentFilePatterns() && Objects.equals(this.excludeAttachmentFilePatterns(), other.excludeAttachmentFilePatterns()) && Objects.equals(this.documentDataFieldName(), other.documentDataFieldName()) && Objects.equals(this.documentTitleFieldName(), other.documentTitleFieldName()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceNowServiceCatalogConfiguration").add("CrawlAttachments", (Object)this.crawlAttachments()).add("IncludeAttachmentFilePatterns", this.hasIncludeAttachmentFilePatterns() ? this.includeAttachmentFilePatterns() : null).add("ExcludeAttachmentFilePatterns", this.hasExcludeAttachmentFilePatterns() ? this.excludeAttachmentFilePatterns() : null).add("DocumentDataFieldName", (Object)this.documentDataFieldName()).add("DocumentTitleFieldName", (Object)this.documentTitleFieldName()).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlAttachments": {
                return Optional.ofNullable(clazz.cast(this.crawlAttachments()));
            }
            case "IncludeAttachmentFilePatterns": {
                return Optional.ofNullable(clazz.cast(this.includeAttachmentFilePatterns()));
            }
            case "ExcludeAttachmentFilePatterns": {
                return Optional.ofNullable(clazz.cast(this.excludeAttachmentFilePatterns()));
            }
            case "DocumentDataFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentDataFieldName()));
            }
            case "DocumentTitleFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentTitleFieldName()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceNowServiceCatalogConfiguration, T> g) {
        return obj -> g.apply((ServiceNowServiceCatalogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean crawlAttachments;
        private List<String> includeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeAttachmentFilePatterns = DefaultSdkAutoConstructList.getInstance();
        private String documentDataFieldName;
        private String documentTitleFieldName;
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNowServiceCatalogConfiguration model) {
            this.crawlAttachments(model.crawlAttachments);
            this.includeAttachmentFilePatterns(model.includeAttachmentFilePatterns);
            this.excludeAttachmentFilePatterns(model.excludeAttachmentFilePatterns);
            this.documentDataFieldName(model.documentDataFieldName);
            this.documentTitleFieldName(model.documentTitleFieldName);
            this.fieldMappings(model.fieldMappings);
        }

        public final Boolean getCrawlAttachments() {
            return this.crawlAttachments;
        }

        @Override
        public final Builder crawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
            return this;
        }

        public final void setCrawlAttachments(Boolean crawlAttachments) {
            this.crawlAttachments = crawlAttachments;
        }

        public final Collection<String> getIncludeAttachmentFilePatterns() {
            if (this.includeAttachmentFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeAttachmentFilePatterns;
        }

        @Override
        public final Builder includeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeAttachmentFilePatterns(String ... includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns(Arrays.asList(includeAttachmentFilePatterns));
            return this;
        }

        public final void setIncludeAttachmentFilePatterns(Collection<String> includeAttachmentFilePatterns) {
            this.includeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(includeAttachmentFilePatterns);
        }

        public final Collection<String> getExcludeAttachmentFilePatterns() {
            if (this.excludeAttachmentFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeAttachmentFilePatterns;
        }

        @Override
        public final Builder excludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAttachmentFilePatterns(String ... excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns(Arrays.asList(excludeAttachmentFilePatterns));
            return this;
        }

        public final void setExcludeAttachmentFilePatterns(Collection<String> excludeAttachmentFilePatterns) {
            this.excludeAttachmentFilePatterns = DataSourceInclusionsExclusionsStringsCopier.copy(excludeAttachmentFilePatterns);
        }

        public final String getDocumentDataFieldName() {
            return this.documentDataFieldName;
        }

        @Override
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        public final String getDocumentTitleFieldName() {
            return this.documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        public ServiceNowServiceCatalogConfiguration build() {
            return new ServiceNowServiceCatalogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceNowServiceCatalogConfiguration> {
        public Builder crawlAttachments(Boolean var1);

        public Builder includeAttachmentFilePatterns(Collection<String> var1);

        public Builder includeAttachmentFilePatterns(String ... var1);

        public Builder excludeAttachmentFilePatterns(Collection<String> var1);

        public Builder excludeAttachmentFilePatterns(String ... var1);

        public Builder documentDataFieldName(String var1);

        public Builder documentTitleFieldName(String var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

