/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsAsyncClient;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsRequest;
import software.amazon.awssdk.services.ivs.model.ListRecordingConfigurationsResponse;
import software.amazon.awssdk.services.ivs.model.RecordingConfigurationSummary;

public class ListRecordingConfigurationsPublisher
implements SdkPublisher<ListRecordingConfigurationsResponse> {
    private final IvsAsyncClient client;
    private final ListRecordingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecordingConfigurationsPublisher(IvsAsyncClient client, ListRecordingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecordingConfigurationsPublisher(IvsAsyncClient client, ListRecordingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecordingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecordingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecordingConfigurationSummary> recordingConfigurations() {
        Function<ListRecordingConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recordingConfigurations() != null) {
                return response.recordingConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecordingConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecordingConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListRecordingConfigurationsResponse> {
        private ListRecordingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecordingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecordingConfigurationsResponse> nextPage(ListRecordingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecordingConfigurationsPublisher.this.client.listRecordingConfigurations(ListRecordingConfigurationsPublisher.this.firstRequest);
            }
            return ListRecordingConfigurationsPublisher.this.client.listRecordingConfigurations((ListRecordingConfigurationsRequest)((Object)ListRecordingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

