/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsecuretunneling.IoTSecureTunnelingAsyncClient;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse;

public class ListTunnelsPublisher
implements SdkPublisher<ListTunnelsResponse> {
    private final IoTSecureTunnelingAsyncClient client;
    private final ListTunnelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTunnelsPublisher(IoTSecureTunnelingAsyncClient client, ListTunnelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTunnelsPublisher(IoTSecureTunnelingAsyncClient client, ListTunnelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTunnelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTunnelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTunnelsResponseFetcher
    implements AsyncPageFetcher<ListTunnelsResponse> {
        private ListTunnelsResponseFetcher() {
        }

        public boolean hasNextPage(ListTunnelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTunnelsResponse> nextPage(ListTunnelsResponse previousPage) {
            if (previousPage == null) {
                return ListTunnelsPublisher.this.client.listTunnels(ListTunnelsPublisher.this.firstRequest);
            }
            return ListTunnelsPublisher.this.client.listTunnels((ListTunnelsRequest)((Object)ListTunnelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

