/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsecuretunneling.model.IoTSecureTunnelingResponse;
import software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummary;
import software.amazon.awssdk.services.iotsecuretunneling.model.TunnelSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTunnelsResponse
extends IoTSecureTunnelingResponse
implements ToCopyableBuilder<Builder, ListTunnelsResponse> {
    private static final SdkField<List<TunnelSummary>> TUNNEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tunnelSummaries").getter(ListTunnelsResponse.getter(ListTunnelsResponse::tunnelSummaries)).setter(ListTunnelsResponse.setter(Builder::tunnelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TunnelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTunnelsResponse.getter(ListTunnelsResponse::nextToken)).setter(ListTunnelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TunnelSummary> tunnelSummaries;
    private final String nextToken;

    private ListTunnelsResponse(BuilderImpl builder) {
        super(builder);
        this.tunnelSummaries = builder.tunnelSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTunnelSummaries() {
        return this.tunnelSummaries != null && !(this.tunnelSummaries instanceof SdkAutoConstructList);
    }

    public final List<TunnelSummary> tunnelSummaries() {
        return this.tunnelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTunnelSummaries() ? this.tunnelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTunnelsResponse)) {
            return false;
        }
        ListTunnelsResponse other = (ListTunnelsResponse)((Object)obj);
        return this.hasTunnelSummaries() == other.hasTunnelSummaries() && Objects.equals(this.tunnelSummaries(), other.tunnelSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTunnelsResponse").add("TunnelSummaries", this.hasTunnelSummaries() ? this.tunnelSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tunnelSummaries": {
                return Optional.ofNullable(clazz.cast(this.tunnelSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTunnelsResponse, T> g) {
        return obj -> g.apply((ListTunnelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSecureTunnelingResponse.BuilderImpl
    implements Builder {
        private List<TunnelSummary> tunnelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTunnelsResponse model) {
            super(model);
            this.tunnelSummaries(model.tunnelSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TunnelSummary.Builder> getTunnelSummaries() {
            List<TunnelSummary.Builder> result = TunnelSummaryListCopier.copyToBuilder(this.tunnelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tunnelSummaries(Collection<TunnelSummary> tunnelSummaries) {
            this.tunnelSummaries = TunnelSummaryListCopier.copy(tunnelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelSummaries(TunnelSummary ... tunnelSummaries) {
            this.tunnelSummaries(Arrays.asList(tunnelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tunnelSummaries(Consumer<TunnelSummary.Builder> ... tunnelSummaries) {
            this.tunnelSummaries(Stream.of(tunnelSummaries).map(c -> (TunnelSummary)((TunnelSummary.Builder)TunnelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTunnelSummaries(Collection<TunnelSummary.BuilderImpl> tunnelSummaries) {
            this.tunnelSummaries = TunnelSummaryListCopier.copyFromBuilder(tunnelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTunnelsResponse build() {
            return new ListTunnelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSecureTunnelingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTunnelsResponse> {
        public Builder tunnelSummaries(Collection<TunnelSummary> var1);

        public Builder tunnelSummaries(TunnelSummary ... var1);

        public Builder tunnelSummaries(Consumer<TunnelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

