/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.services.iotanalytics.model.MessagePayloadsCopier;
import software.amazon.awssdk.services.iotanalytics.model.PipelineActivity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunPipelineActivityRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, RunPipelineActivityRequest> {
    private static final SdkField<PipelineActivity> PIPELINE_ACTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pipelineActivity").getter(RunPipelineActivityRequest.getter(RunPipelineActivityRequest::pipelineActivity)).setter(RunPipelineActivityRequest.setter(Builder::pipelineActivity)).constructor(PipelineActivity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineActivity").build()}).build();
    private static final SdkField<List<SdkBytes>> PAYLOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("payloads").getter(RunPipelineActivityRequest.getter(RunPipelineActivityRequest::payloads)).setter(RunPipelineActivityRequest.setter(Builder::payloads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloads").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ACTIVITY_FIELD, PAYLOADS_FIELD));
    private final PipelineActivity pipelineActivity;
    private final List<SdkBytes> payloads;

    private RunPipelineActivityRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineActivity = builder.pipelineActivity;
        this.payloads = builder.payloads;
    }

    public final PipelineActivity pipelineActivity() {
        return this.pipelineActivity;
    }

    public final boolean hasPayloads() {
        return this.payloads != null && !(this.payloads instanceof SdkAutoConstructList);
    }

    public final List<SdkBytes> payloads() {
        return this.payloads;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineActivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayloads() ? this.payloads() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunPipelineActivityRequest)) {
            return false;
        }
        RunPipelineActivityRequest other = (RunPipelineActivityRequest)((Object)obj);
        return Objects.equals(this.pipelineActivity(), other.pipelineActivity()) && this.hasPayloads() == other.hasPayloads() && Objects.equals(this.payloads(), other.payloads());
    }

    public final String toString() {
        return ToString.builder((String)"RunPipelineActivityRequest").add("PipelineActivity", (Object)this.pipelineActivity()).add("Payloads", this.hasPayloads() ? this.payloads() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pipelineActivity": {
                return Optional.ofNullable(clazz.cast(this.pipelineActivity()));
            }
            case "payloads": {
                return Optional.ofNullable(clazz.cast(this.payloads()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunPipelineActivityRequest, T> g) {
        return obj -> g.apply((RunPipelineActivityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private PipelineActivity pipelineActivity;
        private List<SdkBytes> payloads = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RunPipelineActivityRequest model) {
            super(model);
            this.pipelineActivity(model.pipelineActivity);
            this.payloads(model.payloads);
        }

        public final PipelineActivity.Builder getPipelineActivity() {
            return this.pipelineActivity != null ? this.pipelineActivity.toBuilder() : null;
        }

        @Override
        public final Builder pipelineActivity(PipelineActivity pipelineActivity) {
            this.pipelineActivity = pipelineActivity;
            return this;
        }

        public final void setPipelineActivity(PipelineActivity.BuilderImpl pipelineActivity) {
            this.pipelineActivity = pipelineActivity != null ? pipelineActivity.build() : null;
        }

        public final List<ByteBuffer> getPayloads() {
            if (this.payloads instanceof SdkAutoConstructList) {
                return null;
            }
            return this.payloads == null ? null : this.payloads.stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toList());
        }

        @Override
        public final Builder payloads(Collection<SdkBytes> payloads) {
            this.payloads = MessagePayloadsCopier.copy(payloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloads(SdkBytes ... payloads) {
            this.payloads(Arrays.asList(payloads));
            return this;
        }

        public final void setPayloads(Collection<ByteBuffer> payloads) {
            this.payloads(payloads == null ? null : (Collection)payloads.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RunPipelineActivityRequest build() {
            return new RunPipelineActivityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RunPipelineActivityRequest> {
        public Builder pipelineActivity(PipelineActivity var1);

        default public Builder pipelineActivity(Consumer<PipelineActivity.Builder> pipelineActivity) {
            return this.pipelineActivity((PipelineActivity)((PipelineActivity.Builder)PipelineActivity.builder().applyMutation(pipelineActivity)).build());
        }

        public Builder payloads(Collection<SdkBytes> var1);

        public Builder payloads(SdkBytes ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

