/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot1clickprojects.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot1clickprojects.model.DefaultPlacementAttributeMapCopier;
import software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplate;
import software.amazon.awssdk.services.iot1clickprojects.model.DeviceTemplateMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementTemplate> {
    private static final SdkField<Map<String, String>> DEFAULT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("defaultAttributes").getter(PlacementTemplate.getter(PlacementTemplate::defaultAttributes)).setter(PlacementTemplate.setter(Builder::defaultAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, DeviceTemplate>> DEVICE_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("deviceTemplates").getter(PlacementTemplate.getter(PlacementTemplate::deviceTemplates)).setter(PlacementTemplate.setter(Builder::deviceTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceTemplates").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ATTRIBUTES_FIELD, DEVICE_TEMPLATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> defaultAttributes;
    private final Map<String, DeviceTemplate> deviceTemplates;

    private PlacementTemplate(BuilderImpl builder) {
        this.defaultAttributes = builder.defaultAttributes;
        this.deviceTemplates = builder.deviceTemplates;
    }

    public final boolean hasDefaultAttributes() {
        return this.defaultAttributes != null && !(this.defaultAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultAttributes() {
        return this.defaultAttributes;
    }

    public final boolean hasDeviceTemplates() {
        return this.deviceTemplates != null && !(this.deviceTemplates instanceof SdkAutoConstructMap);
    }

    public final Map<String, DeviceTemplate> deviceTemplates() {
        return this.deviceTemplates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultAttributes() ? this.defaultAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceTemplates() ? this.deviceTemplates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementTemplate)) {
            return false;
        }
        PlacementTemplate other = (PlacementTemplate)obj;
        return this.hasDefaultAttributes() == other.hasDefaultAttributes() && Objects.equals(this.defaultAttributes(), other.defaultAttributes()) && this.hasDeviceTemplates() == other.hasDeviceTemplates() && Objects.equals(this.deviceTemplates(), other.deviceTemplates());
    }

    public final String toString() {
        return ToString.builder((String)"PlacementTemplate").add("DefaultAttributes", this.hasDefaultAttributes() ? this.defaultAttributes() : null).add("DeviceTemplates", this.hasDeviceTemplates() ? this.deviceTemplates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultAttributes": {
                return Optional.ofNullable(clazz.cast(this.defaultAttributes()));
            }
            case "deviceTemplates": {
                return Optional.ofNullable(clazz.cast(this.deviceTemplates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementTemplate, T> g) {
        return obj -> g.apply((PlacementTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> defaultAttributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, DeviceTemplate> deviceTemplates = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementTemplate model) {
            this.defaultAttributes(model.defaultAttributes);
            this.deviceTemplates(model.deviceTemplates);
        }

        public final Map<String, String> getDefaultAttributes() {
            if (this.defaultAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultAttributes;
        }

        @Override
        public final Builder defaultAttributes(Map<String, String> defaultAttributes) {
            this.defaultAttributes = DefaultPlacementAttributeMapCopier.copy(defaultAttributes);
            return this;
        }

        public final void setDefaultAttributes(Map<String, String> defaultAttributes) {
            this.defaultAttributes = DefaultPlacementAttributeMapCopier.copy(defaultAttributes);
        }

        public final Map<String, DeviceTemplate.Builder> getDeviceTemplates() {
            Map<String, DeviceTemplate.Builder> result = DeviceTemplateMapCopier.copyToBuilder(this.deviceTemplates);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder deviceTemplates(Map<String, DeviceTemplate> deviceTemplates) {
            this.deviceTemplates = DeviceTemplateMapCopier.copy(deviceTemplates);
            return this;
        }

        public final void setDeviceTemplates(Map<String, DeviceTemplate.BuilderImpl> deviceTemplates) {
            this.deviceTemplates = DeviceTemplateMapCopier.copyFromBuilder(deviceTemplates);
        }

        public PlacementTemplate build() {
            return new PlacementTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementTemplate> {
        public Builder defaultAttributes(Map<String, String> var1);

        public Builder deviceTemplates(Map<String, DeviceTemplate> var1);
    }
}

