/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.inspector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.inspector.InspectorAsyncClient;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsRequest;
import software.amazon.awssdk.services.inspector.model.PreviewAgentsResponse;

public class PreviewAgentsPublisher
implements SdkPublisher<PreviewAgentsResponse> {
    private final InspectorAsyncClient client;
    private final PreviewAgentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public PreviewAgentsPublisher(InspectorAsyncClient client, PreviewAgentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private PreviewAgentsPublisher(InspectorAsyncClient client, PreviewAgentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new PreviewAgentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super PreviewAgentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class PreviewAgentsResponseFetcher
    implements AsyncPageFetcher<PreviewAgentsResponse> {
        private PreviewAgentsResponseFetcher() {
        }

        public boolean hasNextPage(PreviewAgentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<PreviewAgentsResponse> nextPage(PreviewAgentsResponse previousPage) {
            if (previousPage == null) {
                return PreviewAgentsPublisher.this.client.previewAgents(PreviewAgentsPublisher.this.firstRequest);
            }
            return PreviewAgentsPublisher.this.client.previewAgents((PreviewAgentsRequest)((Object)PreviewAgentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

