/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Logs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Logs> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(S3Logs.getter(S3Logs::s3BucketName)).setter(S3Logs.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3KeyPrefix").getter(S3Logs.getter(S3Logs::s3KeyPrefix)).setter(S3Logs.setter(Builder::s3KeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3KeyPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, S3_KEY_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String s3KeyPrefix;

    private S3Logs(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Logs)) {
            return false;
        }
        S3Logs other = (S3Logs)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"S3Logs").add("S3BucketName", (Object)this.s3BucketName()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "s3KeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3KeyPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Logs, T> g) {
        return obj -> g.apply((S3Logs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Logs model) {
            this.s3BucketName(model.s3BucketName);
            this.s3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public S3Logs build() {
            return new S3Logs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Logs> {
        public Builder s3BucketName(String var1);

        public Builder s3KeyPrefix(String var1);
    }
}

