/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Format {
    AUTO("AUTO"),
    NUMBER("NUMBER"),
    CURRENCY("CURRENCY"),
    DATE("DATE"),
    TIME("TIME"),
    DATE_TIME("DATE_TIME"),
    PERCENTAGE("PERCENTAGE"),
    TEXT("TEXT"),
    ACCOUNTING("ACCOUNTING"),
    CONTACT("CONTACT"),
    ROWLINK("ROWLINK"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Format(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Format fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Format.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Format> knownValues() {
        return Stream.of(Format.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

