/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Filter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Filter> {
    private static final SdkField<String> FORMULA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formula").getter(Filter.getter(Filter::formula)).setter(Filter.setter(Builder::formula)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formula").build()}).build();
    private static final SdkField<String> CONTEXT_ROW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contextRowId").getter(Filter.getter(Filter::contextRowId)).setter(Filter.setter(Builder::contextRowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextRowId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMULA_FIELD, CONTEXT_ROW_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String formula;
    private final String contextRowId;

    private Filter(BuilderImpl builder) {
        this.formula = builder.formula;
        this.contextRowId = builder.contextRowId;
    }

    public final String formula() {
        return this.formula;
    }

    public final String contextRowId() {
        return this.contextRowId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formula());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextRowId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.formula(), other.formula()) && Objects.equals(this.contextRowId(), other.contextRowId());
    }

    public final String toString() {
        return ToString.builder((String)"Filter").add("Formula", (Object)(this.formula() == null ? null : "*** Sensitive Data Redacted ***")).add("ContextRowId", (Object)this.contextRowId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "formula": {
                return Optional.ofNullable(clazz.cast(this.formula()));
            }
            case "contextRowId": {
                return Optional.ofNullable(clazz.cast(this.contextRowId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String formula;
        private String contextRowId;

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            this.formula(model.formula);
            this.contextRowId(model.contextRowId);
        }

        public final String getFormula() {
            return this.formula;
        }

        @Override
        public final Builder formula(String formula) {
            this.formula = formula;
            return this;
        }

        public final void setFormula(String formula) {
            this.formula = formula;
        }

        public final String getContextRowId() {
            return this.contextRowId;
        }

        @Override
        public final Builder contextRowId(String contextRowId) {
            this.contextRowId = contextRowId;
            return this;
        }

        public final void setContextRowId(String contextRowId) {
            this.contextRowId = contextRowId;
        }

        public Filter build() {
            return new Filter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Filter> {
        public Builder formula(String var1);

        public Builder contextRowId(String var1);
    }
}

