/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.GroundStationData;
import software.amazon.awssdk.services.groundstation.model.GroundStationListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroundStationsResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListGroundStationsResponse> {
    private static final SdkField<List<GroundStationData>> GROUND_STATION_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groundStationList").getter(ListGroundStationsResponse.getter(ListGroundStationsResponse::groundStationList)).setter(ListGroundStationsResponse.setter(Builder::groundStationList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStationList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroundStationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGroundStationsResponse.getter(ListGroundStationsResponse::nextToken)).setter(ListGroundStationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUND_STATION_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<GroundStationData> groundStationList;
    private final String nextToken;

    private ListGroundStationsResponse(BuilderImpl builder) {
        super(builder);
        this.groundStationList = builder.groundStationList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGroundStationList() {
        return this.groundStationList != null && !(this.groundStationList instanceof SdkAutoConstructList);
    }

    public final List<GroundStationData> groundStationList() {
        return this.groundStationList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroundStationList() ? this.groundStationList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroundStationsResponse)) {
            return false;
        }
        ListGroundStationsResponse other = (ListGroundStationsResponse)((Object)obj);
        return this.hasGroundStationList() == other.hasGroundStationList() && Objects.equals(this.groundStationList(), other.groundStationList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroundStationsResponse").add("GroundStationList", this.hasGroundStationList() ? this.groundStationList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groundStationList": {
                return Optional.ofNullable(clazz.cast(this.groundStationList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroundStationsResponse, T> g) {
        return obj -> g.apply((ListGroundStationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private List<GroundStationData> groundStationList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroundStationsResponse model) {
            super(model);
            this.groundStationList(model.groundStationList);
            this.nextToken(model.nextToken);
        }

        public final List<GroundStationData.Builder> getGroundStationList() {
            List<GroundStationData.Builder> result = GroundStationListCopier.copyToBuilder(this.groundStationList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder groundStationList(Collection<GroundStationData> groundStationList) {
            this.groundStationList = GroundStationListCopier.copy(groundStationList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStationList(GroundStationData ... groundStationList) {
            this.groundStationList(Arrays.asList(groundStationList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStationList(Consumer<GroundStationData.Builder> ... groundStationList) {
            this.groundStationList(Stream.of(groundStationList).map(c -> (GroundStationData)((GroundStationData.Builder)GroundStationData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroundStationList(Collection<GroundStationData.BuilderImpl> groundStationList) {
            this.groundStationList = GroundStationListCopier.copyFromBuilder(groundStationList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListGroundStationsResponse build() {
            return new ListGroundStationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroundStationsResponse> {
        public Builder groundStationList(Collection<GroundStationData> var1);

        public Builder groundStationList(GroundStationData ... var1);

        public Builder groundStationList(Consumer<GroundStationData.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

