/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.CoreDeviceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoreDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoreDevice> {
    private static final SdkField<String> CORE_DEVICE_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("coreDeviceThingName").getter(CoreDevice.getter(CoreDevice::coreDeviceThingName)).setter(CoreDevice.setter(Builder::coreDeviceThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreDeviceThingName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CoreDevice.getter(CoreDevice::statusAsString)).setter(CoreDevice.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_UPDATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusUpdateTimestamp").getter(CoreDevice.getter(CoreDevice::lastStatusUpdateTimestamp)).setter(CoreDevice.setter(Builder::lastStatusUpdateTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusUpdateTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_DEVICE_THING_NAME_FIELD, STATUS_FIELD, LAST_STATUS_UPDATE_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String coreDeviceThingName;
    private final String status;
    private final Instant lastStatusUpdateTimestamp;

    private CoreDevice(BuilderImpl builder) {
        this.coreDeviceThingName = builder.coreDeviceThingName;
        this.status = builder.status;
        this.lastStatusUpdateTimestamp = builder.lastStatusUpdateTimestamp;
    }

    public final String coreDeviceThingName() {
        return this.coreDeviceThingName;
    }

    public final CoreDeviceStatus status() {
        return CoreDeviceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastStatusUpdateTimestamp() {
        return this.lastStatusUpdateTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.coreDeviceThingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusUpdateTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoreDevice)) {
            return false;
        }
        CoreDevice other = (CoreDevice)obj;
        return Objects.equals(this.coreDeviceThingName(), other.coreDeviceThingName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastStatusUpdateTimestamp(), other.lastStatusUpdateTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CoreDevice").add("CoreDeviceThingName", (Object)this.coreDeviceThingName()).add("Status", (Object)this.statusAsString()).add("LastStatusUpdateTimestamp", (Object)this.lastStatusUpdateTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "coreDeviceThingName": {
                return Optional.ofNullable(clazz.cast(this.coreDeviceThingName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastStatusUpdateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastStatusUpdateTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoreDevice, T> g) {
        return obj -> g.apply((CoreDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String coreDeviceThingName;
        private String status;
        private Instant lastStatusUpdateTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CoreDevice model) {
            this.coreDeviceThingName(model.coreDeviceThingName);
            this.status(model.status);
            this.lastStatusUpdateTimestamp(model.lastStatusUpdateTimestamp);
        }

        public final String getCoreDeviceThingName() {
            return this.coreDeviceThingName;
        }

        @Override
        public final Builder coreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
            return this;
        }

        public final void setCoreDeviceThingName(String coreDeviceThingName) {
            this.coreDeviceThingName = coreDeviceThingName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CoreDeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastStatusUpdateTimestamp() {
            return this.lastStatusUpdateTimestamp;
        }

        @Override
        public final Builder lastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
            return this;
        }

        public final void setLastStatusUpdateTimestamp(Instant lastStatusUpdateTimestamp) {
            this.lastStatusUpdateTimestamp = lastStatusUpdateTimestamp;
        }

        public CoreDevice build() {
            return new CoreDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoreDevice> {
        public Builder coreDeviceThingName(String var1);

        public Builder status(String var1);

        public Builder status(CoreDeviceStatus var1);

        public Builder lastStatusUpdateTimestamp(Instant var1);
    }
}

