/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.services.greengrass.model.ResourceDefinitionVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceDefinitionVersionResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, GetResourceDefinitionVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetResourceDefinitionVersionResponse.getter(GetResourceDefinitionVersionResponse::arn)).setter(GetResourceDefinitionVersionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTimestamp").getter(GetResourceDefinitionVersionResponse.getter(GetResourceDefinitionVersionResponse::creationTimestamp)).setter(GetResourceDefinitionVersionResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final SdkField<ResourceDefinitionVersion> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Definition").getter(GetResourceDefinitionVersionResponse.getter(GetResourceDefinitionVersionResponse::definition)).setter(GetResourceDefinitionVersionResponse.setter(Builder::definition)).constructor(ResourceDefinitionVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Definition").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetResourceDefinitionVersionResponse.getter(GetResourceDefinitionVersionResponse::id)).setter(GetResourceDefinitionVersionResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(GetResourceDefinitionVersionResponse.getter(GetResourceDefinitionVersionResponse::version)).setter(GetResourceDefinitionVersionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIMESTAMP_FIELD, DEFINITION_FIELD, ID_FIELD, VERSION_FIELD));
    private final String arn;
    private final String creationTimestamp;
    private final ResourceDefinitionVersion definition;
    private final String id;
    private final String version;

    private GetResourceDefinitionVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTimestamp = builder.creationTimestamp;
        this.definition = builder.definition;
        this.id = builder.id;
        this.version = builder.version;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationTimestamp() {
        return this.creationTimestamp;
    }

    public final ResourceDefinitionVersion definition() {
        return this.definition;
    }

    public final String id() {
        return this.id;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceDefinitionVersionResponse)) {
            return false;
        }
        GetResourceDefinitionVersionResponse other = (GetResourceDefinitionVersionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceDefinitionVersionResponse").add("Arn", (Object)this.arn()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("Definition", (Object)this.definition()).add("Id", (Object)this.id()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "Definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResourceDefinitionVersionResponse, T> g) {
        return obj -> g.apply((GetResourceDefinitionVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String creationTimestamp;
        private ResourceDefinitionVersion definition;
        private String id;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceDefinitionVersionResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTimestamp(model.creationTimestamp);
            this.definition(model.definition);
            this.id(model.id);
            this.version(model.version);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(String creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final ResourceDefinitionVersion.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(ResourceDefinitionVersion definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(ResourceDefinitionVersion.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public GetResourceDefinitionVersionResponse build() {
            return new GetResourceDefinitionVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceDefinitionVersionResponse> {
        public Builder arn(String var1);

        public Builder creationTimestamp(String var1);

        public Builder definition(ResourceDefinitionVersion var1);

        default public Builder definition(Consumer<ResourceDefinitionVersion.Builder> definition) {
            return this.definition((ResourceDefinitionVersion)((ResourceDefinitionVersion.Builder)ResourceDefinitionVersion.builder().applyMutation(definition)).build());
        }

        public Builder id(String var1);

        public Builder version(String var1);
    }
}

