/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.NodeIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResumeWorkflowRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, ResumeWorkflowRunRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ResumeWorkflowRunRequest.getter(ResumeWorkflowRunRequest::name)).setter(ResumeWorkflowRunRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunId").getter(ResumeWorkflowRunRequest.getter(ResumeWorkflowRunRequest::runId)).setter(ResumeWorkflowRunRequest.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunId").build()}).build();
    private static final SdkField<List<String>> NODE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeIds").getter(ResumeWorkflowRunRequest.getter(ResumeWorkflowRunRequest::nodeIds)).setter(ResumeWorkflowRunRequest.setter(Builder::nodeIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUN_ID_FIELD, NODE_IDS_FIELD));
    private final String name;
    private final String runId;
    private final List<String> nodeIds;

    private ResumeWorkflowRunRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.runId = builder.runId;
        this.nodeIds = builder.nodeIds;
    }

    public final String name() {
        return this.name;
    }

    public final String runId() {
        return this.runId;
    }

    public final boolean hasNodeIds() {
        return this.nodeIds != null && !(this.nodeIds instanceof SdkAutoConstructList);
    }

    public final List<String> nodeIds() {
        return this.nodeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeIds() ? this.nodeIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResumeWorkflowRunRequest)) {
            return false;
        }
        ResumeWorkflowRunRequest other = (ResumeWorkflowRunRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.runId(), other.runId()) && this.hasNodeIds() == other.hasNodeIds() && Objects.equals(this.nodeIds(), other.nodeIds());
    }

    public final String toString() {
        return ToString.builder((String)"ResumeWorkflowRunRequest").add("Name", (Object)this.name()).add("RunId", (Object)this.runId()).add("NodeIds", this.hasNodeIds() ? this.nodeIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RunId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
            case "NodeIds": {
                return Optional.ofNullable(clazz.cast(this.nodeIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResumeWorkflowRunRequest, T> g) {
        return obj -> g.apply((ResumeWorkflowRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String name;
        private String runId;
        private List<String> nodeIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResumeWorkflowRunRequest model) {
            super(model);
            this.name(model.name);
            this.runId(model.runId);
            this.nodeIds(model.nodeIds);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRunId() {
            return this.runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        public final Collection<String> getNodeIds() {
            if (this.nodeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeIds;
        }

        @Override
        public final Builder nodeIds(Collection<String> nodeIds) {
            this.nodeIds = NodeIdListCopier.copy(nodeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIds(String ... nodeIds) {
            this.nodeIds(Arrays.asList(nodeIds));
            return this;
        }

        public final void setNodeIds(Collection<String> nodeIds) {
            this.nodeIds = NodeIdListCopier.copy(nodeIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResumeWorkflowRunRequest build() {
            return new ResumeWorkflowRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResumeWorkflowRunRequest> {
        public Builder name(String var1);

        public Builder runId(String var1);

        public Builder nodeIds(Collection<String> var1);

        public Builder nodeIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

