/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.Compatibility;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.RegistryId;
import software.amazon.awssdk.services.glue.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSchemaRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, CreateSchemaRequest> {
    private static final SdkField<RegistryId> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistryId").getter(CreateSchemaRequest.getter(CreateSchemaRequest::registryId)).setter(CreateSchemaRequest.setter(Builder::registryId)).constructor(RegistryId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(CreateSchemaRequest.getter(CreateSchemaRequest::schemaName)).setter(CreateSchemaRequest.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFormat").getter(CreateSchemaRequest.getter(CreateSchemaRequest::dataFormatAsString)).setter(CreateSchemaRequest.setter(Builder::dataFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()}).build();
    private static final SdkField<String> COMPATIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Compatibility").getter(CreateSchemaRequest.getter(CreateSchemaRequest::compatibilityAsString)).setter(CreateSchemaRequest.setter(Builder::compatibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Compatibility").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateSchemaRequest.getter(CreateSchemaRequest::description)).setter(CreateSchemaRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateSchemaRequest.getter(CreateSchemaRequest::tags)).setter(CreateSchemaRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaDefinition").getter(CreateSchemaRequest.getter(CreateSchemaRequest::schemaDefinition)).setter(CreateSchemaRequest.setter(Builder::schemaDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaDefinition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, SCHEMA_NAME_FIELD, DATA_FORMAT_FIELD, COMPATIBILITY_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, SCHEMA_DEFINITION_FIELD));
    private final RegistryId registryId;
    private final String schemaName;
    private final String dataFormat;
    private final String compatibility;
    private final String description;
    private final Map<String, String> tags;
    private final String schemaDefinition;

    private CreateSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.schemaName = builder.schemaName;
        this.dataFormat = builder.dataFormat;
        this.compatibility = builder.compatibility;
        this.description = builder.description;
        this.tags = builder.tags;
        this.schemaDefinition = builder.schemaDefinition;
    }

    public final RegistryId registryId() {
        return this.registryId;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final DataFormat dataFormat() {
        return DataFormat.fromValue(this.dataFormat);
    }

    public final String dataFormatAsString() {
        return this.dataFormat;
    }

    public final Compatibility compatibility() {
        return Compatibility.fromValue(this.compatibility);
    }

    public final String compatibilityAsString() {
        return this.compatibility;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String schemaDefinition() {
        return this.schemaDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaDefinition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSchemaRequest)) {
            return false;
        }
        CreateSchemaRequest other = (CreateSchemaRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.dataFormatAsString(), other.dataFormatAsString()) && Objects.equals(this.compatibilityAsString(), other.compatibilityAsString()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.schemaDefinition(), other.schemaDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSchemaRequest").add("RegistryId", (Object)this.registryId()).add("SchemaName", (Object)this.schemaName()).add("DataFormat", (Object)this.dataFormatAsString()).add("Compatibility", (Object)this.compatibilityAsString()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("SchemaDefinition", (Object)this.schemaDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "DataFormat": {
                return Optional.ofNullable(clazz.cast(this.dataFormatAsString()));
            }
            case "Compatibility": {
                return Optional.ofNullable(clazz.cast(this.compatibilityAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SchemaDefinition": {
                return Optional.ofNullable(clazz.cast(this.schemaDefinition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSchemaRequest, T> g) {
        return obj -> g.apply((CreateSchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private RegistryId registryId;
        private String schemaName;
        private String dataFormat;
        private String compatibility;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String schemaDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSchemaRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.schemaName(model.schemaName);
            this.dataFormat(model.dataFormat);
            this.compatibility(model.compatibility);
            this.description(model.description);
            this.tags(model.tags);
            this.schemaDefinition(model.schemaDefinition);
        }

        public final RegistryId.Builder getRegistryId() {
            return this.registryId != null ? this.registryId.toBuilder() : null;
        }

        @Override
        public final Builder registryId(RegistryId registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(RegistryId.BuilderImpl registryId) {
            this.registryId = registryId != null ? registryId.build() : null;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public final String getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        public final String getCompatibility() {
            return this.compatibility;
        }

        @Override
        public final Builder compatibility(String compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        @Override
        public final Builder compatibility(Compatibility compatibility) {
            this.compatibility(compatibility == null ? null : compatibility.toString());
            return this;
        }

        public final void setCompatibility(String compatibility) {
            this.compatibility = compatibility;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getSchemaDefinition() {
            return this.schemaDefinition;
        }

        @Override
        public final Builder schemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
            return this;
        }

        public final void setSchemaDefinition(String schemaDefinition) {
            this.schemaDefinition = schemaDefinition;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSchemaRequest build() {
            return new CreateSchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSchemaRequest> {
        public Builder registryId(RegistryId var1);

        default public Builder registryId(Consumer<RegistryId.Builder> registryId) {
            return this.registryId((RegistryId)((RegistryId.Builder)RegistryId.builder().applyMutation(registryId)).build());
        }

        public Builder schemaName(String var1);

        public Builder dataFormat(String var1);

        public Builder dataFormat(DataFormat var1);

        public Builder compatibility(String var1);

        public Builder compatibility(Compatibility var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder schemaDefinition(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

