/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glacier.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ActionCode {
    ARCHIVE_RETRIEVAL("ArchiveRetrieval"),
    INVENTORY_RETRIEVAL("InventoryRetrieval"),
    SELECT("Select"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ActionCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ActionCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionCode> knownValues() {
        return Stream.of(ActionCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

