/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.Instance;

public class DescribeInstancesPublisher
implements SdkPublisher<DescribeInstancesResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstancesPublisher(GameLiftAsyncClient client, DescribeInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstancesPublisher(GameLiftAsyncClient client, DescribeInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Instance> instances() {
        Function<DescribeInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instances() != null) {
                return response.instances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeInstancesResponse> {
        private DescribeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstancesResponse> nextPage(DescribeInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancesPublisher.this.client.describeInstances(DescribeInstancesPublisher.this.firstRequest);
            }
            return DescribeInstancesPublisher.this.client.describeInstances((DescribeInstancesRequest)((Object)DescribeInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

