/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.fms.model.DependentServiceName;
import software.amazon.awssdk.services.fms.model.EvaluationResult;
import software.amazon.awssdk.services.fms.model.EvaluationResultsCopier;
import software.amazon.awssdk.services.fms.model.IssueInfoMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyComplianceStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyComplianceStatus> {
    private static final SdkField<String> POLICY_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyOwner").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::policyOwner)).setter(PolicyComplianceStatus.setter(Builder::policyOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyOwner").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::policyId)).setter(PolicyComplianceStatus.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyName").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::policyName)).setter(PolicyComplianceStatus.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()}).build();
    private static final SdkField<String> MEMBER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberAccount").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::memberAccount)).setter(PolicyComplianceStatus.setter(Builder::memberAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberAccount").build()}).build();
    private static final SdkField<List<EvaluationResult>> EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EvaluationResults").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::evaluationResults)).setter(PolicyComplianceStatus.setter(Builder::evaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::lastUpdated)).setter(PolicyComplianceStatus.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<Map<String, String>> ISSUE_INFO_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IssueInfoMap").getter(PolicyComplianceStatus.getter(PolicyComplianceStatus::issueInfoMapAsStrings)).setter(PolicyComplianceStatus.setter(Builder::issueInfoMapWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueInfoMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_OWNER_FIELD, POLICY_ID_FIELD, POLICY_NAME_FIELD, MEMBER_ACCOUNT_FIELD, EVALUATION_RESULTS_FIELD, LAST_UPDATED_FIELD, ISSUE_INFO_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyOwner;
    private final String policyId;
    private final String policyName;
    private final String memberAccount;
    private final List<EvaluationResult> evaluationResults;
    private final Instant lastUpdated;
    private final Map<String, String> issueInfoMap;

    private PolicyComplianceStatus(BuilderImpl builder) {
        this.policyOwner = builder.policyOwner;
        this.policyId = builder.policyId;
        this.policyName = builder.policyName;
        this.memberAccount = builder.memberAccount;
        this.evaluationResults = builder.evaluationResults;
        this.lastUpdated = builder.lastUpdated;
        this.issueInfoMap = builder.issueInfoMap;
    }

    public final String policyOwner() {
        return this.policyOwner;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String policyName() {
        return this.policyName;
    }

    public final String memberAccount() {
        return this.memberAccount;
    }

    public final boolean hasEvaluationResults() {
        return this.evaluationResults != null && !(this.evaluationResults instanceof SdkAutoConstructList);
    }

    public final List<EvaluationResult> evaluationResults() {
        return this.evaluationResults;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final Map<DependentServiceName, String> issueInfoMap() {
        return IssueInfoMapCopier.copyStringToEnum(this.issueInfoMap);
    }

    public final boolean hasIssueInfoMap() {
        return this.issueInfoMap != null && !(this.issueInfoMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> issueInfoMapAsStrings() {
        return this.issueInfoMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluationResults() ? this.evaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssueInfoMap() ? this.issueInfoMapAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyComplianceStatus)) {
            return false;
        }
        PolicyComplianceStatus other = (PolicyComplianceStatus)obj;
        return Objects.equals(this.policyOwner(), other.policyOwner()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.memberAccount(), other.memberAccount()) && this.hasEvaluationResults() == other.hasEvaluationResults() && Objects.equals(this.evaluationResults(), other.evaluationResults()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && this.hasIssueInfoMap() == other.hasIssueInfoMap() && Objects.equals(this.issueInfoMapAsStrings(), other.issueInfoMapAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyComplianceStatus").add("PolicyOwner", (Object)this.policyOwner()).add("PolicyId", (Object)this.policyId()).add("PolicyName", (Object)this.policyName()).add("MemberAccount", (Object)this.memberAccount()).add("EvaluationResults", this.hasEvaluationResults() ? this.evaluationResults() : null).add("LastUpdated", (Object)this.lastUpdated()).add("IssueInfoMap", this.hasIssueInfoMap() ? this.issueInfoMapAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyOwner": {
                return Optional.ofNullable(clazz.cast(this.policyOwner()));
            }
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "PolicyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "MemberAccount": {
                return Optional.ofNullable(clazz.cast(this.memberAccount()));
            }
            case "EvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.evaluationResults()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "IssueInfoMap": {
                return Optional.ofNullable(clazz.cast(this.issueInfoMapAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyComplianceStatus, T> g) {
        return obj -> g.apply((PolicyComplianceStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyOwner;
        private String policyId;
        private String policyName;
        private String memberAccount;
        private List<EvaluationResult> evaluationResults = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdated;
        private Map<String, String> issueInfoMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyComplianceStatus model) {
            this.policyOwner(model.policyOwner);
            this.policyId(model.policyId);
            this.policyName(model.policyName);
            this.memberAccount(model.memberAccount);
            this.evaluationResults(model.evaluationResults);
            this.lastUpdated(model.lastUpdated);
            this.issueInfoMapWithStrings(model.issueInfoMap);
        }

        public final String getPolicyOwner() {
            return this.policyOwner;
        }

        @Override
        public final Builder policyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
            return this;
        }

        public final void setPolicyOwner(String policyOwner) {
            this.policyOwner = policyOwner;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getMemberAccount() {
            return this.memberAccount;
        }

        @Override
        public final Builder memberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
            return this;
        }

        public final void setMemberAccount(String memberAccount) {
            this.memberAccount = memberAccount;
        }

        public final List<EvaluationResult.Builder> getEvaluationResults() {
            List<EvaluationResult.Builder> result = EvaluationResultsCopier.copyToBuilder(this.evaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder evaluationResults(Collection<EvaluationResult> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copy(evaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(EvaluationResult ... evaluationResults) {
            this.evaluationResults(Arrays.asList(evaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationResults(Consumer<EvaluationResult.Builder> ... evaluationResults) {
            this.evaluationResults(Stream.of(evaluationResults).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvaluationResults(Collection<EvaluationResult.BuilderImpl> evaluationResults) {
            this.evaluationResults = EvaluationResultsCopier.copyFromBuilder(evaluationResults);
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final Map<String, String> getIssueInfoMap() {
            if (this.issueInfoMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.issueInfoMap;
        }

        @Override
        public final Builder issueInfoMapWithStrings(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
            return this;
        }

        @Override
        public final Builder issueInfoMap(Map<DependentServiceName, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copyEnumToString(issueInfoMap);
            return this;
        }

        public final void setIssueInfoMap(Map<String, String> issueInfoMap) {
            this.issueInfoMap = IssueInfoMapCopier.copy(issueInfoMap);
        }

        public PolicyComplianceStatus build() {
            return new PolicyComplianceStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyComplianceStatus> {
        public Builder policyOwner(String var1);

        public Builder policyId(String var1);

        public Builder policyName(String var1);

        public Builder memberAccount(String var1);

        public Builder evaluationResults(Collection<EvaluationResult> var1);

        public Builder evaluationResults(EvaluationResult ... var1);

        public Builder evaluationResults(Consumer<EvaluationResult.Builder> ... var1);

        public Builder lastUpdated(Instant var1);

        public Builder issueInfoMapWithStrings(Map<String, String> var1);

        public Builder issueInfoMap(Map<DependentServiceName, String> var1);
    }
}

