/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fms.model.FmsResponse;
import software.amazon.awssdk.services.fms.model.SecurityServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProtectionStatusResponse
extends FmsResponse
implements ToCopyableBuilder<Builder, GetProtectionStatusResponse> {
    private static final SdkField<String> ADMIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminAccountId").getter(GetProtectionStatusResponse.getter(GetProtectionStatusResponse::adminAccountId)).setter(GetProtectionStatusResponse.setter(Builder::adminAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccountId").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(GetProtectionStatusResponse.getter(GetProtectionStatusResponse::serviceTypeAsString)).setter(GetProtectionStatusResponse.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Data").getter(GetProtectionStatusResponse.getter(GetProtectionStatusResponse::data)).setter(GetProtectionStatusResponse.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetProtectionStatusResponse.getter(GetProtectionStatusResponse::nextToken)).setter(GetProtectionStatusResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_ID_FIELD, SERVICE_TYPE_FIELD, DATA_FIELD, NEXT_TOKEN_FIELD));
    private final String adminAccountId;
    private final String serviceType;
    private final String data;
    private final String nextToken;

    private GetProtectionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccountId = builder.adminAccountId;
        this.serviceType = builder.serviceType;
        this.data = builder.data;
        this.nextToken = builder.nextToken;
    }

    public final String adminAccountId() {
        return this.adminAccountId;
    }

    public final SecurityServiceType serviceType() {
        return SecurityServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String data() {
        return this.data;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtectionStatusResponse)) {
            return false;
        }
        GetProtectionStatusResponse other = (GetProtectionStatusResponse)((Object)obj);
        return Objects.equals(this.adminAccountId(), other.adminAccountId()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetProtectionStatusResponse").add("AdminAccountId", (Object)this.adminAccountId()).add("ServiceType", (Object)this.serviceTypeAsString()).add("Data", (Object)this.data()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccountId": {
                return Optional.ofNullable(clazz.cast(this.adminAccountId()));
            }
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtectionStatusResponse, T> g) {
        return obj -> g.apply((GetProtectionStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FmsResponse.BuilderImpl
    implements Builder {
        private String adminAccountId;
        private String serviceType;
        private String data;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtectionStatusResponse model) {
            super(model);
            this.adminAccountId(model.adminAccountId);
            this.serviceType(model.serviceType);
            this.data(model.data);
            this.nextToken(model.nextToken);
        }

        public final String getAdminAccountId() {
            return this.adminAccountId;
        }

        @Override
        public final Builder adminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
            return this;
        }

        public final void setAdminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(SecurityServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetProtectionStatusResponse build() {
            return new GetProtectionStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProtectionStatusResponse> {
        public Builder adminAccountId(String var1);

        public Builder serviceType(String var1);

        public Builder serviceType(SecurityServiceType var1);

        public Builder data(String var1);

        public Builder nextToken(String var1);
    }
}

