/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FailureReason {
    INTERNAL_ERROR("INTERNAL_ERROR"),
    USER_ERROR("USER_ERROR"),
    VALIDATION_ERROR("VALIDATION_ERROR"),
    CLUSTER_UNAVAILABLE("CLUSTER_UNAVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FailureReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FailureReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FailureReason> knownValues() {
        return Stream.of(FailureReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

